/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glevel.support;

import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;

public abstract class AbstractMultiLevelSource
implements MultiLevelSource {
    private final MultiLevelModel multiLevelModel;
    private final RenderedImage[] levelImages;

    protected AbstractMultiLevelSource(MultiLevelModel multiLevelModel) {
        this.multiLevelModel = multiLevelModel;
        this.levelImages = new RenderedImage[multiLevelModel.getLevelCount()];
    }

    @Override
    public MultiLevelModel getModel() {
        return this.multiLevelModel;
    }

    @Override
    public synchronized RenderedImage getImage(int level) {
        this.checkLevel(level);
        RenderedImage levelImage = this.levelImages[level];
        if (levelImage == null) {
            this.levelImages[level] = levelImage = this.createImage(level);
        }
        return levelImage;
    }

    @Override
    public Shape getImageShape(int level) {
        return null;
    }

    protected abstract RenderedImage createImage(int var1);

    @Override
    public synchronized void reset() {
        for (int level = 0; level < this.levelImages.length; ++level) {
            RenderedImage levelImage = this.levelImages[level];
            if (levelImage instanceof PlanarImage) {
                PlanarImage planarImage = (PlanarImage)levelImage;
                planarImage.dispose();
            }
            this.levelImages[level] = null;
        }
    }

    protected synchronized void checkLevel(int level) {
        if (level < 0 || level >= this.getModel().getLevelCount()) {
            throw new IllegalArgumentException("level=" + level + " < " + this.getModel().getLevelCount());
        }
    }
}

