/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer.swing;

import com.bc.ceres.core.Assert;
import com.bc.ceres.glayer.CollectionLayer;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glayer.support.LayerViewInvalidationListener;
import com.bc.ceres.glayer.swing.DefaultLayerCanvasModel;
import com.bc.ceres.glayer.swing.LayerCanvasModel;
import com.bc.ceres.glayer.swing.NavControl;
import com.bc.ceres.glayer.swing.WakefulComponent;
import com.bc.ceres.grender.AdjustableView;
import com.bc.ceres.grender.InteractiveRendering;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.grender.support.DefaultViewport;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LayerCanvas
extends JPanel
implements AdjustableView {
    private static final boolean DEBUG = Boolean.getBoolean("snap.renderer.debug");
    private LayerCanvasModel model;
    private CanvasRendering canvasRendering;
    private boolean navControlShown;
    private WakefulComponent navControlWrapper;
    private boolean initiallyZoomingAll;
    private boolean zoomedAll;
    private Rectangle2D maxVisibleModelBounds;
    private double minZoomFactor;
    private double maxZoomFactor;
    private double defaultZoomFactor;
    private ArrayList<Overlay> overlays;
    private final ModelChangeHandler modelChangeHandler;
    private boolean antialiasing;
    private LayerFilter layerFilter;

    public LayerCanvas() {
        this(new CollectionLayer());
    }

    public LayerCanvas(Layer layer) {
        this(layer, new DefaultViewport(true));
    }

    public LayerCanvas(Layer layer, Viewport viewport) {
        this(new DefaultLayerCanvasModel(layer, viewport));
    }

    public LayerCanvas(LayerCanvasModel model) {
        super(null);
        Assert.notNull((Object)model, (String)"model");
        this.setOpaque(true);
        this.modelChangeHandler = new ModelChangeHandler();
        this.model = model;
        this.model.addChangeListener(this.modelChangeHandler);
        this.canvasRendering = new CanvasRendering();
        this.overlays = new ArrayList(4);
        this.initiallyZoomingAll = true;
        this.zoomedAll = false;
        this.antialiasing = true;
        this.setNavControlShown(false);
        if (!model.getViewport().getViewBounds().isEmpty()) {
            this.setBounds(model.getViewport().getViewBounds());
        }
    }

    public LayerCanvasModel getModel() {
        return this.model;
    }

    public void setModel(LayerCanvasModel newModel) {
        Assert.notNull((Object)newModel, (String)"newModel");
        LayerCanvasModel oldModel = this.model;
        if (newModel != oldModel) {
            oldModel.removeChangeListener(this.modelChangeHandler);
            this.zoomedAll = false;
            this.model = newModel;
            if (!this.getBounds().isEmpty()) {
                this.model.getViewport().setViewBounds(this.getBounds());
            }
            this.updateAdjustableViewProperties();
            this.model.addChangeListener(this.modelChangeHandler);
            this.firePropertyChange("model", oldModel, newModel);
            this.repaint();
        }
    }

    public Layer getLayer() {
        return this.model.getLayer();
    }

    public LayerFilter getLayerFilter() {
        return this.layerFilter;
    }

    public void setLayerFilter(LayerFilter layerFilter) {
        LayerFilter oldLayerFilter = this.layerFilter;
        if (oldLayerFilter != layerFilter) {
            this.layerFilter = layerFilter;
            this.repaint();
            this.firePropertyChange("layerFilter", oldLayerFilter, layerFilter);
        }
    }

    public void dispose() {
        if (this.model != null) {
            this.model.removeChangeListener(this.modelChangeHandler);
        }
    }

    public void addOverlay(Overlay overlay) {
        this.overlays.add(overlay);
        this.repaint();
    }

    public void removeOverlay(Overlay overlay) {
        this.overlays.remove(overlay);
        this.repaint();
    }

    public boolean isNavControlShown() {
        return this.navControlShown;
    }

    public boolean isAntialiasing() {
        return this.antialiasing;
    }

    public void setAntialiasing(boolean antialiasing) {
        boolean oldValue = this.antialiasing;
        if (oldValue != antialiasing) {
            this.antialiasing = antialiasing;
            this.firePropertyChange("antialiasing", oldValue, antialiasing);
            this.repaint();
        }
    }

    public void setNavControlShown(boolean navControlShown) {
        boolean oldValue = this.navControlShown;
        if (oldValue != navControlShown) {
            if (navControlShown) {
                NavControl navControl = new NavControl(new NavControlModelImpl(this.getViewport()));
                this.navControlWrapper = new WakefulComponent(navControl);
                this.add(this.navControlWrapper);
            } else {
                this.remove(this.navControlWrapper);
                this.navControlWrapper = null;
            }
            this.validate();
            this.navControlShown = navControlShown;
        }
    }

    public boolean isInitiallyZoomingAll() {
        return this.initiallyZoomingAll;
    }

    public void setInitiallyZoomingAll(boolean initiallyZoomingAll) {
        this.initiallyZoomingAll = initiallyZoomingAll;
    }

    public void zoomAll() {
        this.getViewport().zoom(this.getMaxVisibleModelBounds());
    }

    @Override
    public Viewport getViewport() {
        return this.model.getViewport();
    }

    @Override
    public Rectangle2D getMaxVisibleModelBounds() {
        return this.maxVisibleModelBounds;
    }

    @Override
    public double getMinZoomFactor() {
        return this.minZoomFactor;
    }

    @Override
    public double getMaxZoomFactor() {
        return this.maxZoomFactor;
    }

    @Override
    public double getDefaultZoomFactor() {
        return this.defaultZoomFactor;
    }

    private void updateAdjustableViewProperties() {
        this.maxVisibleModelBounds = LayerCanvas.computeMaxVisibleModelBounds(this.getLayer().getModelBounds(), this.getViewport().getOrientation());
        this.minZoomFactor = LayerCanvas.computeMinZoomFactor(this.getViewport().getViewBounds(), this.maxVisibleModelBounds);
        Layer layer = this.getLayer();
        double minScale = LayerCanvas.computeMinImageToModelScale(layer);
        if (minScale > 0.0) {
            this.defaultZoomFactor = 1.0 / minScale;
            this.maxZoomFactor = 32.0 / minScale;
        } else {
            this.defaultZoomFactor = this.minZoomFactor;
            this.maxZoomFactor = 1000.0 * this.minZoomFactor;
        }
        if (DEBUG) {
            System.out.println("LayerCanvas.updateAdjustableViewProperties():");
            System.out.println("  zoomFactor            = " + this.getViewport().getZoomFactor());
            System.out.println("  minZoomFactor         = " + this.minZoomFactor);
            System.out.println("  maxZoomFactor         = " + this.maxZoomFactor);
            System.out.println("  defaultZoomFactor     = " + this.defaultZoomFactor);
            System.out.println("  maxVisibleModelBounds = " + this.maxVisibleModelBounds);
        }
    }

    static double computeMinZoomFactor(Rectangle2D viewBounds, Rectangle2D maxVisibleModelBounds) {
        double sh;
        double vw = viewBounds.getWidth();
        double vh = viewBounds.getHeight();
        double mw = maxVisibleModelBounds.getWidth();
        double mh = maxVisibleModelBounds.getHeight();
        double sw = mw > 0.0 ? vw / mw : 0.0;
        double d = sh = mh > 0.0 ? vh / mh : 0.0;
        double s = sw > 0.0 && sh > 0.0 ? Math.min(sw, sh) : (sw > 0.0 ? sw : (sh > 0.0 ? sh : 0.0));
        return 0.5 * s;
    }

    static double computeMinImageToModelScale(Layer layer) {
        return LayerCanvas.computeMinImageToModelScale(layer, 0.0);
    }

    private static double computeMinImageToModelScale(Layer layer, double minScale) {
        AffineTransform i2m;
        double scale;
        ImageLayer imageLayer;
        if (layer instanceof ImageLayer && (imageLayer = (ImageLayer)layer).getModelBounds() != null && (scale = Math.sqrt(Math.abs((i2m = imageLayer.getImageToModelTransform()).getDeterminant()))) > 0.0 && (minScale <= 0.0 || scale < minScale)) {
            minScale = scale;
        }
        for (Layer childLayer : layer.getChildren()) {
            minScale = LayerCanvas.computeMinImageToModelScale(childLayer, minScale);
        }
        return minScale;
    }

    public static Rectangle2D computeMaxVisibleModelBounds(Rectangle2D modelBounds, double orientation) {
        if (modelBounds == null) {
            return new Rectangle();
        }
        if (orientation == 0.0) {
            return modelBounds;
        }
        AffineTransform t = new AffineTransform();
        t.rotate(orientation, modelBounds.getCenterX(), modelBounds.getCenterY());
        return t.createTransformedShape(modelBounds).getBounds2D();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.getViewport().setViewBounds(this.getBounds());
    }

    @Override
    public void doLayout() {
        if (this.navControlShown && this.navControlWrapper != null) {
            this.navControlWrapper.setLocation(4, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        long t0;
        long l = t0 = DEBUG ? System.nanoTime() : 0L;
        if (this.initiallyZoomingAll && !this.zoomedAll && this.maxVisibleModelBounds != null && !this.maxVisibleModelBounds.isEmpty()) {
            this.zoomedAll = true;
            this.zoomAll();
        }
        Graphics2D g2d = (Graphics2D)g;
        Object antiAliasing = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object textAntiAliasing = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        if (this.antialiasing) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        try {
            super.paintComponent(g);
            this.canvasRendering.setGraphics2D((Graphics2D)g);
            this.getLayer().render(this.canvasRendering, this.layerFilter);
            if (!this.isPaintingForPrint()) {
                for (Overlay overlay : this.overlays) {
                    overlay.paintOverlay(this, this.canvasRendering);
                }
            }
        }
        finally {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antiAliasing);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, textAntiAliasing);
        }
        if (DEBUG) {
            double dt = (double)(System.nanoTime() - t0) / 1000000.0;
            System.out.println("LayerCanvas.paintComponent() took " + dt + " ms");
        }
    }

    private class ModelChangeHandler
    extends LayerViewInvalidationListener
    implements LayerCanvasModel.ChangeListener {
        private ModelChangeHandler() {
        }

        @Override
        public void handleViewInvalidation(Layer layer, Rectangle2D modelRegion) {
            LayerCanvas.this.updateAdjustableViewProperties();
            if (modelRegion != null) {
                AffineTransform m2v = LayerCanvas.this.getViewport().getModelToViewTransform();
                Rectangle viewRegion = m2v.createTransformedShape(modelRegion).getBounds();
                LayerCanvas.this.repaint(viewRegion);
            } else {
                LayerCanvas.this.repaint();
            }
        }

        @Override
        public void handleViewportChanged(Viewport viewport, boolean orientationChanged) {
            LayerCanvas.this.updateAdjustableViewProperties();
            LayerCanvas.this.repaint();
        }
    }

    public static interface Overlay {
        public void paintOverlay(LayerCanvas var1, Rendering var2);
    }

    private static class NavControlModelImpl
    implements NavControl.NavControlModel {
        private final Viewport viewport;

        public NavControlModelImpl(Viewport viewport) {
            this.viewport = viewport;
        }

        @Override
        public double getCurrentAngle() {
            return Math.toDegrees(this.viewport.getOrientation());
        }

        @Override
        public void handleRotate(double rotationAngle) {
            this.viewport.setOrientation(Math.toRadians(rotationAngle));
        }

        @Override
        public void handleMove(double moveDirX, double moveDirY) {
            this.viewport.moveViewDelta(16.0 * moveDirX, 16.0 * moveDirY);
        }

        @Override
        public void handleScale(double scaleDir) {
            double oldZoomFactor = this.viewport.getZoomFactor();
            double newZoomFactor = (1.0 + 0.1 * scaleDir) * oldZoomFactor;
            this.viewport.setZoomFactor(newZoomFactor);
        }
    }

    private class CanvasRendering
    implements InteractiveRendering {
        private Graphics2D graphics2D;

        @Override
        public Graphics2D getGraphics() {
            return this.graphics2D;
        }

        void setGraphics2D(Graphics2D graphics2D) {
            this.graphics2D = graphics2D;
        }

        @Override
        public Viewport getViewport() {
            return LayerCanvas.this.getModel().getViewport();
        }

        @Override
        public void invalidateRegion(Rectangle region) {
            LayerCanvas.this.repaint(region.x, region.y, region.width, region.height);
        }

        @Override
        public void invokeLater(Runnable runnable) {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

