/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.dom;

import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.core.Assert;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppDomReader;
import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;

public class XppDomElement
implements DomElement {
    private final XppDom xppDom;
    private DomElement parent;
    private HashMap<XppDom, DomElement> children;

    public XppDomElement(String name) {
        this(new XppDom(name));
    }

    public XppDomElement(XppDom xppDom) {
        Assert.notNull((Object)xppDom, (String)"xppDom");
        Assert.notNull((Object)xppDom.getName(), (String)"xppDom.getName()");
        this.xppDom = xppDom;
    }

    public XppDom getXppDom() {
        return this.xppDom;
    }

    public String getName() {
        return this.xppDom.getName();
    }

    public String getValue() {
        return this.xppDom.getValue();
    }

    @Override
    public void setValue(String value) {
        this.xppDom.setValue(value);
    }

    public DomElement getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DomElement parent) {
        if (parent instanceof XppDomElement) {
            XppDomElement xppDomElement = (XppDomElement)parent;
            this.xppDom.setParent(xppDomElement.getXppDom());
        }
        this.parent = parent;
    }

    public DomElement[] getChildren() {
        return this.getChildren(this.xppDom.getChildren());
    }

    public DomElement[] getChildren(String elementName) {
        return this.getChildren(this.xppDom.getChildren(elementName));
    }

    @Override
    public DomElement getChild(int index) {
        XppDom child = this.xppDom.getChild(index);
        if (child == null) {
            return null;
        }
        return this.getChild(child);
    }

    public DomElement getChild(String elementName) {
        XppDom child = this.xppDom.getChild(elementName);
        if (child == null) {
            return null;
        }
        return this.getChild(child);
    }

    @Override
    public int getChildCount() {
        return this.xppDom.getChildCount();
    }

    @Override
    public DomElement createChild(String name) {
        XppDomElement child = new XppDomElement(new XppDom(name));
        this.addChild(child);
        return child;
    }

    @Override
    public void addChild(DomElement child) {
        XppDom dom = child instanceof XppDomElement ? ((XppDomElement)child).getXppDom() : this.toXppDom(child);
        this.xppDom.addChild(dom);
        child.setParent(this);
    }

    public String[] getAttributeNames() {
        return this.xppDom.getAttributeNames();
    }

    public String getAttribute(String attributeName) {
        return this.xppDom.getAttribute(attributeName);
    }

    @Override
    public void setAttribute(String name, String value) {
        this.xppDom.setAttribute(name, value);
    }

    @Override
    public String toXml() {
        StringWriter writer = new StringWriter();
        new HierarchicalStreamCopier().copy((HierarchicalStreamReader)new XppDomReader(this.xppDom), (HierarchicalStreamWriter)new PrettyPrintWriter((Writer)writer));
        return writer.toString();
    }

    private XppDom toXppDom(DomElement domElement) {
        DomElement[] children;
        String[] names;
        XppDom xppDom = new XppDom(domElement.getName());
        if (domElement.getValue() != null) {
            xppDom.setValue(domElement.getValue());
        }
        for (String name : names = domElement.getAttributeNames()) {
            xppDom.setAttribute(name, domElement.getAttribute(name));
        }
        for (DomElement child : children = (DomElement[])domElement.getChildren()) {
            xppDom.addChild(this.toXppDom(child));
        }
        return xppDom;
    }

    private DomElement[] getChildren(XppDom[] xppChildren) {
        DomElement[] domElements = new XppDomElement[xppChildren.length];
        for (int i = 0; i < xppChildren.length; ++i) {
            domElements[i] = this.getChild(xppChildren[i]);
        }
        return domElements;
    }

    private DomElement getChild(XppDom child) {
        DomElement childElement;
        if (this.children != null) {
            childElement = this.children.get(child);
            if (childElement != null) {
                return childElement;
            }
        } else {
            this.children = new HashMap();
        }
        childElement = new XppDomElement(child);
        childElement.setParent(this);
        this.children.put(child, childElement);
        return childElement;
    }
}

