/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.dom;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.dom.DomConverter;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.XStreamDomElementReader;
import com.bc.ceres.binding.dom.XStreamDomElementWriter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class XStreamDomConverter
implements DomConverter {
    private final Class<?> valueType;
    private XStream xStream;

    public XStreamDomConverter(Class<?> valueType) {
        this.valueType = valueType;
    }

    @Override
    public Class<?> getValueType() {
        return this.valueType;
    }

    @Override
    public Object convertDomToValue(DomElement parentElement, Object value) throws ConversionException, ValidationException {
        try {
            return this.getXStream().unmarshal((HierarchicalStreamReader)new XStreamDomElementReader(parentElement), value);
        }
        catch (Throwable e) {
            throw new ConversionException(e);
        }
    }

    @Override
    public void convertValueToDom(Object value, DomElement parentElement) throws ConversionException {
        this.getXStream().marshal(value, (HierarchicalStreamWriter)new XStreamDomElementWriter(parentElement));
    }

    public XStream getXStream() {
        if (this.xStream == null) {
            this.xStream = new XStream();
            this.configureXStream(this.xStream);
        }
        return this.xStream;
    }

    protected void configureXStream(XStream xStream) {
    }
}

