/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import java.awt.Font;

public class FontConverter
implements Converter<Font> {
    public static final FontConverter INSTANCE = new FontConverter();

    @Override
    public Class<Font> getValueType() {
        return Font.class;
    }

    @Override
    public Font parse(String text) throws ConversionException {
        if (text.isEmpty()) {
            return null;
        }
        try {
            return Font.decode(text);
        }
        catch (Exception e) {
            throw new ConversionException("Illegal font format: " + text);
        }
    }

    @Override
    public String format(Font font) {
        if (font == null) {
            return "";
        }
        return String.format("%s-%s-%d", font.getName(), FontConverter.getStyleName(font), font.getSize());
    }

    private static String getStyleName(Font font) {
        StringBuilder sb = new StringBuilder();
        if (font.isPlain()) {
            sb.append("plain");
        } else {
            if (font.isBold()) {
                sb.append("bold");
            }
            if (font.isItalic()) {
                sb.append("italic");
            }
        }
        return sb.toString();
    }
}

