/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding;

import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ConverterRegistry;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySetDescriptor;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.binding.dom.DomConverter;
import com.bc.ceres.binding.validators.ArrayValidator;
import com.bc.ceres.binding.validators.IntervalValidator;
import com.bc.ceres.binding.validators.MultiValidator;
import com.bc.ceres.binding.validators.NotEmptyValidator;
import com.bc.ceres.binding.validators.NotNullValidator;
import com.bc.ceres.binding.validators.PatternValidator;
import com.bc.ceres.binding.validators.TypeValidator;
import com.bc.ceres.binding.validators.ValueSetValidator;
import com.bc.ceres.core.Assert;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PropertyDescriptor {
    private final String name;
    private final Class<?> type;
    private volatile Validator effectiveValidator;
    private final Map<String, Object> attributes;
    private PropertyChangeSupport attributeChangeSupport;
    private PropertySetDescriptor propertySetDescriptor;

    public PropertyDescriptor(String name, Class<?> type) {
        this(name, type, new HashMap<String, Object>(8));
    }

    public PropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        this(propertyDescriptor.getName(), propertyDescriptor.getType(), propertyDescriptor.attributes);
    }

    public PropertyDescriptor(String name, Class<?> type, Map<String, Object> attributes) {
        Assert.notNull((Object)name, (String)"name");
        Assert.notNull(type, (String)"type");
        Assert.notNull(attributes, (String)"attributes");
        this.name = name;
        this.type = type;
        this.attributes = new HashMap<String, Object>(attributes);
        if (type.isPrimitive()) {
            this.setNotNull(true);
        }
        this.setDisplayName(PropertyDescriptor.createDisplayName(name));
        if (type.isEnum() && this.getValueSet() == null) {
            this.setValueSet(new ValueSet(type.getEnumConstants()));
        }
    }

    private static boolean equals(Object a, Object b) {
        return a == b || a != null && b != null && a.equals(b);
    }

    public static String getDisplayName(PropertyDescriptor propertyDescriptor) {
        String label = propertyDescriptor.getDisplayName();
        if (label != null) {
            return label;
        }
        String name = propertyDescriptor.getName().replace("_", " ");
        return PropertyDescriptor.createDisplayName(name);
    }

    public static String createDisplayName(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (i == 0) {
                sb.append(Character.toUpperCase(ch));
                continue;
            }
            if (i < name.length() - 1 && Character.isUpperCase(ch) && Character.isLowerCase(name.charAt(i + 1))) {
                sb.append(' ');
                sb.append(Character.toLowerCase(ch));
                continue;
            }
            if (ch == '_') {
                sb.append(' ');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getDisplayName() {
        return (String)this.getAttribute("displayName");
    }

    public void setDisplayName(String displayName) {
        Assert.notNull((Object)displayName, (String)"displayName");
        this.setAttribute("displayName", displayName);
    }

    public String getAlias() {
        return (String)this.getAttribute("alias");
    }

    public void setAlias(String alias) {
        this.setAttribute("alias", alias);
    }

    public String getUnit() {
        return (String)this.getAttribute("unit");
    }

    public void setUnit(String unit) {
        this.setAttribute("unit", unit);
    }

    public String getDescription() {
        return (String)this.getAttribute("description");
    }

    public void setDescription(String description) {
        this.setAttribute("description", description);
    }

    public boolean isNotNull() {
        return this.getBooleanProperty("notNull");
    }

    public void setNotNull(boolean notNull) {
        this.setAttribute("notNull", notNull);
    }

    public boolean isNotEmpty() {
        return this.getBooleanProperty("notEmpty");
    }

    public void setNotEmpty(boolean notEmpty) {
        this.setAttribute("notEmpty", notEmpty);
    }

    public boolean isDeprecated() {
        return this.getBooleanProperty("deprecated");
    }

    public void setDeprecated(boolean deprecated) {
        this.setAttribute("deprecated", deprecated);
    }

    public boolean isTransient() {
        return this.getBooleanProperty("transient");
    }

    public void setTransient(boolean b) {
        this.setAttribute("transient", b);
    }

    public String getFormat() {
        return (String)this.getAttribute("format");
    }

    public void setFormat(String format) {
        this.setAttribute("format", format);
    }

    public ValueRange getValueRange() {
        return (ValueRange)this.getAttribute("valueRange");
    }

    public void setValueRange(ValueRange valueRange) {
        this.setAttribute("valueRange", valueRange);
    }

    public Pattern getPattern() {
        return (Pattern)this.getAttribute("pattern");
    }

    public void setPattern(Pattern pattern) {
        this.setAttribute("pattern", pattern);
    }

    public Object getDefaultValue() {
        return this.getAttribute("defaultValue");
    }

    public void setDefaultValue(Object defaultValue) {
        this.setAttribute("defaultValue", defaultValue);
    }

    public ValueSet getValueSet() {
        return (ValueSet)this.getAttribute("valueSet");
    }

    public void setValueSet(ValueSet valueSet) {
        this.setAttribute("valueSet", valueSet);
    }

    public Converter<?> getConverter() {
        return this.getConverter(false);
    }

    public void setConverter(Converter<?> converter) {
        this.setAttribute("converter", converter);
    }

    public Converter<?> getConverter(boolean notNull) {
        Converter converter = (Converter)this.getAttribute("converter");
        if (converter == null && notNull) {
            throw new IllegalStateException("no converter defined for value '" + this.getName() + "'");
        }
        return converter;
    }

    public void setDefaultConverter() {
        boolean useItemConverter;
        boolean hasItemAlias = this.getItemAlias() != null && !this.getItemAlias().isEmpty();
        boolean bl = useItemConverter = this.getType().isArray() && hasItemAlias;
        if (!useItemConverter) {
            this.setConverter(ConverterRegistry.getInstance().getConverter(this.getType()));
        }
    }

    public DomConverter getDomConverter() {
        return (DomConverter)this.getAttribute("domConverter");
    }

    public void setDomConverter(DomConverter converter) {
        this.setAttribute("domConverter", converter);
    }

    public Validator getValidator() {
        return (Validator)this.getAttribute("validator");
    }

    public void setValidator(Validator validator) {
        this.setAttribute("validator", validator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Validator getEffectiveValidator() {
        if (this.effectiveValidator == null) {
            PropertyDescriptor propertyDescriptor = this;
            synchronized (propertyDescriptor) {
                if (this.effectiveValidator == null) {
                    this.effectiveValidator = this.createEffectiveValidator();
                }
            }
        }
        return this.effectiveValidator;
    }

    public PropertySetDescriptor getPropertySetDescriptor() {
        return this.propertySetDescriptor;
    }

    public void setPropertySetDescriptor(PropertySetDescriptor propertySetDescriptor) {
        this.propertySetDescriptor = propertySetDescriptor;
    }

    public String getItemAlias() {
        return (String)this.getAttribute("itemAlias");
    }

    public void setItemAlias(String alias) {
        this.setAttribute("itemAlias", alias);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        Object oldValue = this.getAttribute(name);
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
        if (!PropertyDescriptor.equals(oldValue, value)) {
            this.firePropertyChange(name, value, oldValue);
        }
    }

    public final void addAttributeChangeListener(PropertyChangeListener listener) {
        if (this.attributeChangeSupport == null) {
            this.attributeChangeSupport = new PropertyChangeSupport(this);
        }
        this.attributeChangeSupport.addPropertyChangeListener(listener);
    }

    public final void removeAttributeChangeListener(PropertyChangeListener listener) {
        if (this.attributeChangeSupport != null) {
            this.attributeChangeSupport.removePropertyChangeListener(listener);
        }
    }

    public PropertyChangeListener[] getAttributeChangeListeners() {
        if (this.attributeChangeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.attributeChangeSupport.getPropertyChangeListeners();
    }

    void initDefaults() {
        if (this.getConverter() == null) {
            this.setDefaultConverter();
        }
        if (this.getDefaultValue() == null && this.getType().isPrimitive()) {
            this.setDefaultValue(Property.PRIMITIVE_ZERO_VALUES.get(this.getType()));
        }
    }

    private void firePropertyChange(String propertyName, Object newValue, Object oldValue) {
        if (this.attributeChangeSupport == null) {
            return;
        }
        PropertyChangeListener[] propertyChangeListeners = this.getAttributeChangeListeners();
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener propertyChangeListener : propertyChangeListeners) {
            propertyChangeListener.propertyChange(evt);
        }
    }

    public boolean getBooleanProperty(String name) {
        Object v = this.getAttribute(name);
        return v != null && (Boolean)v != false;
    }

    private Validator createEffectiveValidator() {
        ArrayList<Validator> validators = new ArrayList<Validator>(3);
        if (this.isNotNull()) {
            validators.add(new NotNullValidator());
        }
        validators.add(new TypeValidator());
        if (this.isNotEmpty()) {
            validators.add(new NotEmptyValidator());
        }
        if (this.getPattern() != null) {
            validators.add(new PatternValidator(this.getPattern()));
        }
        if (this.getValueSet() != null) {
            Validator valueSetValidator = new ValueSetValidator(this);
            if (this.getType().isArray()) {
                valueSetValidator = new ArrayValidator(valueSetValidator);
            }
            validators.add(valueSetValidator);
        }
        if (this.getValueRange() != null) {
            validators.add(new IntervalValidator(this.getValueRange()));
        }
        if (this.getValidator() != null) {
            validators.add(this.getValidator());
        }
        Validator validator = validators.isEmpty() ? null : (validators.size() == 1 ? (Validator)validators.get(0) : new MultiValidator(validators));
        return validator;
    }
}

