/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ConverterRegistry;
import com.bc.ceres.binding.PropertyAccessor;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.accessors.ClassFieldAccessor;
import com.bc.ceres.binding.accessors.DefaultPropertyAccessor;
import com.bc.ceres.binding.accessors.MapEntryAccessor;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class Property {
    static final HashMap<Class<?>, Object> PRIMITIVE_ZERO_VALUES = new HashMap(17);
    private final PropertyDescriptor descriptor;
    private final PropertyAccessor accessor;
    private PropertyContainer container;

    public Property(PropertyDescriptor descriptor, PropertyAccessor accessor) {
        this.descriptor = descriptor;
        this.accessor = accessor;
    }

    public static Property create(String name, Class<?> type) {
        return Property.createImpl(Property.createDescriptor(name, type), new DefaultPropertyAccessor(), null);
    }

    public static Property create(String name, Object value) {
        return Property.createImpl(Property.createDescriptor(name, value.getClass()), new DefaultPropertyAccessor(), value);
    }

    public static <T> Property create(String name, Class<? extends T> type, T defaultValue, boolean notNull) {
        PropertyDescriptor descriptor = Property.createDescriptor(name, type);
        if (notNull) {
            descriptor.setDefaultValue(defaultValue);
            descriptor.setNotNull(true);
        }
        return new Property(descriptor, new DefaultPropertyAccessor(defaultValue));
    }

    public static Property createForField(Object object, String name) {
        Field field = Property.getField(object, name);
        PropertyDescriptor descriptor = Property.createDescriptor(name, field.getType());
        boolean isDeprecated = field.getAnnotation(Deprecated.class) != null;
        descriptor.setDeprecated(isDeprecated);
        return Property.createImpl(descriptor, new ClassFieldAccessor(object, field));
    }

    public static Property createForField(Object object, String name, Object value) {
        Field field = Property.getField(object, name);
        PropertyDescriptor descriptor = Property.createDescriptor(name, field.getType());
        boolean isDeprecated = field.getAnnotation(Deprecated.class) != null;
        descriptor.setDeprecated(isDeprecated);
        return Property.createImpl(descriptor, new ClassFieldAccessor(object, field), value);
    }

    public static Property createForMapEntry(Map<String, Object> map, String name, Class<?> type) {
        return Property.createImpl(Property.createDescriptor(name, type), new MapEntryAccessor(map, name), null);
    }

    public static Property createForMapEntry(Map<String, Object> map, String name, Class<?> type, Object value) {
        return Property.createImpl(Property.createDescriptor(name, type), new MapEntryAccessor(map, name), value);
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public PropertyContainer getContainer() {
        return this.container;
    }

    public void setContainer(PropertyContainer container) {
        this.container = container;
    }

    public Validator getValidator() {
        return this.descriptor.getEffectiveValidator();
    }

    public String getValueAsText() {
        Converter<?> converter = this.descriptor.getConverter(true);
        return converter.format(this.getValue());
    }

    public void setValueFromText(String text) throws ValidationException {
        Object value;
        Converter<?> converter = this.descriptor.getConverter(true);
        try {
            value = converter.parse(text);
        }
        catch (ConversionException e) {
            throw new ValidationException(MessageFormat.format("Value for ''{0}'' is invalid.\n''{1}''", this.getDescriptor().getDisplayName(), e.getMessage()), e);
        }
        this.setValue(value);
    }

    public String getName() {
        return this.getDescriptor().getName();
    }

    public Class<?> getType() {
        return this.getDescriptor().getType();
    }

    public <T> T getValue() {
        Object value = this.accessor.getValue();
        if (value == null && this.descriptor.getType().isPrimitive()) {
            return (T)PRIMITIVE_ZERO_VALUES.get(this.descriptor.getType());
        }
        return (T)value;
    }

    public void setValue(Object value) throws ValidationException {
        Object oldValue = this.getValue();
        if (this.equalObjects(oldValue, value)) {
            return;
        }
        this.validate(value);
        this.accessor.setValue(value);
        if (this.container != null) {
            this.container.getPropertyChangeSupport().firePropertyChange(this.descriptor.getName(), oldValue, value);
        }
    }

    private boolean equalObjects(Object oldValue, Object newValue) {
        if (oldValue == newValue) {
            return true;
        }
        if (oldValue == null) {
            return false;
        }
        if (oldValue instanceof Number && newValue instanceof Number) {
            Number number = (Number)newValue;
            Object epsValue = this.descriptor.getAttribute("eps");
            if (epsValue instanceof Number) {
                if (oldValue instanceof Float) {
                    float eps;
                    float v2;
                    float v1 = ((Float)oldValue).floatValue();
                    float deltaSig = v1 - (v2 = number.floatValue());
                    float deltaAbs = Math.abs(deltaSig);
                    return deltaAbs < (eps = ((Number)epsValue).floatValue());
                }
                if (oldValue instanceof Double) {
                    double eps;
                    double v2;
                    double v1 = (Double)oldValue;
                    double deltaSig = v1 - (v2 = (double)number.floatValue());
                    double deltaAbs = Math.abs(deltaSig);
                    return deltaAbs < (eps = (double)((Number)epsValue).floatValue());
                }
            }
        }
        return oldValue.equals(newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(Object value) throws ValidationException {
        Property property = this;
        synchronized (property) {
            Validator validator = this.getValidator();
            if (validator != null) {
                validator.validateValue(this, value);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.container == null) {
            throw new IllegalStateException("container == null");
        }
        this.container.getPropertyChangeSupport().addPropertyChangeListener(this.descriptor.getName(), l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.container == null) {
            throw new IllegalStateException("container == null");
        }
        this.container.getPropertyChangeSupport().removePropertyChangeListener(this.descriptor.getName(), l);
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.getName() + ",value=" + this.getValueAsText() + "]";
    }

    private static PropertyDescriptor createDescriptor(String name, Class<?> type) {
        return new PropertyDescriptor(name, type);
    }

    private static Property createImpl(PropertyDescriptor descriptor, PropertyAccessor accessor) {
        Property vm = new Property(descriptor, accessor);
        vm.getDescriptor().setConverter(ConverterRegistry.getInstance().getConverter(descriptor.getType()));
        return vm;
    }

    private static Property createImpl(PropertyDescriptor descriptor, PropertyAccessor accessor, Object value) {
        Property vm = Property.createImpl(descriptor, accessor);
        if (value == null && descriptor.getType().isPrimitive()) {
            value = PRIMITIVE_ZERO_VALUES.get(descriptor.getType());
        }
        try {
            vm.setValue(value);
        }
        catch (ValidationException e) {
            throw new IllegalStateException(e);
        }
        return vm;
    }

    private static Field getField(Object object, String name) {
        Field field;
        try {
            field = object.getClass().getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        return field;
    }

    static {
        PRIMITIVE_ZERO_VALUES.put(Boolean.TYPE, false);
        PRIMITIVE_ZERO_VALUES.put(Character.TYPE, Character.valueOf('\u0000'));
        PRIMITIVE_ZERO_VALUES.put(Byte.TYPE, (byte)0);
        PRIMITIVE_ZERO_VALUES.put(Short.TYPE, (short)0);
        PRIMITIVE_ZERO_VALUES.put(Integer.TYPE, 0);
        PRIMITIVE_ZERO_VALUES.put(Long.TYPE, 0L);
        PRIMITIVE_ZERO_VALUES.put(Float.TYPE, Float.valueOf(0.0f));
        PRIMITIVE_ZERO_VALUES.put(Double.TYPE, 0.0);
        PRIMITIVE_ZERO_VALUES.put(Boolean.class, false);
        PRIMITIVE_ZERO_VALUES.put(Character.class, Character.valueOf('\u0000'));
        PRIMITIVE_ZERO_VALUES.put(Byte.class, (byte)0);
        PRIMITIVE_ZERO_VALUES.put(Short.class, (short)0);
        PRIMITIVE_ZERO_VALUES.put(Integer.class, 0);
        PRIMITIVE_ZERO_VALUES.put(Long.class, 0L);
        PRIMITIVE_ZERO_VALUES.put(Float.class, Float.valueOf(0.0f));
        PRIMITIVE_ZERO_VALUES.put(Double.class, 0.0);
    }
}

