/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.selection.support;

import com.bc.ceres.swing.selection.AbstractSelectionContext;
import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.support.DefaultSelection;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class TreeSelectionContext
extends AbstractSelectionContext {
    private final TreeSelectionListener treeSelectionListener = new TreeSelectionHandler();
    private JTree tree;

    public TreeSelectionContext(JTree tree) {
        this.tree = tree;
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
    }

    @Override
    public Selection getSelection() {
        TreePath[] treePaths = this.tree.getSelectionPaths();
        DefaultSelection<TreePath> selection = treePaths != null && treePaths.length > 0 ? new DefaultSelection<TreePath>(treePaths) : DefaultSelection.EMPTY;
        return selection;
    }

    @Override
    public void setSelection(Selection selection) {
        Object[] objects = selection.getSelectedValues();
        if (objects instanceof TreePath[] && objects.length > 0) {
            this.tree.setSelectionPaths((TreePath[])objects);
        } else if (objects == null || objects.length == 0) {
            this.tree.clearSelection();
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setTree(JTree tree) {
        if (tree != this.tree) {
            this.tree.removeTreeSelectionListener(this.treeSelectionListener);
            this.tree = tree;
            this.tree.addTreeSelectionListener(this.treeSelectionListener);
            this.fireSelectionChange(this.getSelection());
        }
    }

    protected void handleTreeSelectionChanged(TreeSelectionEvent event) {
        this.fireSelectionChange(this.getSelection());
    }

    private class TreeSelectionHandler
    implements TreeSelectionListener {
        private TreeSelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreeSelectionContext.this.handleTreeSelectionChanged(e);
        }
    }
}

