/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.selection.support;

import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionContext;
import java.util.Vector;

public class SelectionChangeSupport {
    private final Vector<SelectionChangeListener> selectionListeners;
    private final Object realEventSource;

    public SelectionChangeSupport() {
        this(null);
    }

    public SelectionChangeSupport(Object realEventSource) {
        this.realEventSource = realEventSource != null ? realEventSource : this;
        this.selectionListeners = new Vector();
    }

    public Object getRealEventSource() {
        return this.realEventSource;
    }

    public void addSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionListeners.remove(listener);
    }

    public SelectionChangeListener[] getSelectionChangeListeners() {
        return this.selectionListeners.toArray(new SelectionChangeListener[this.selectionListeners.size()]);
    }

    public SelectionChangeEvent createEvent(SelectionContext selectionContext, Selection selection) {
        return new SelectionChangeEvent(this.realEventSource, selectionContext, selection);
    }

    public void fireSelectionChange(SelectionContext selectionContext, Selection selection) {
        this.fireSelectionChange(this.createEvent(selectionContext, selection));
    }

    public void fireSelectionChange(SelectionChangeEvent event) {
        for (SelectionChangeListener selectionChangeListener : this.getSelectionChangeListeners()) {
            selectionChangeListener.selectionChanged(event);
        }
    }

    public void fireSelectionContextChange(SelectionChangeEvent event) {
        for (SelectionChangeListener selectionChangeListener : this.getSelectionChangeListeners()) {
            selectionChangeListener.selectionContextChanged(event);
        }
    }
}

