/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.selection.support;

import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionContext;
import com.bc.ceres.swing.selection.SelectionManager;
import com.bc.ceres.swing.selection.support.SelectionChangeSupport;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;

public class DefaultSelectionManager
implements SelectionManager {
    private final SelectionChangeSupport selectionChangeSupport;
    private final SelectionChangeMulticaster selectionChangeMulticaster;
    private SelectionContext selectionContext;
    private Selection selection;
    private Clipboard clipboard;

    public DefaultSelectionManager() {
        this(null);
    }

    public DefaultSelectionManager(Object realEventSource) {
        Object eventSource = realEventSource != null ? realEventSource : this;
        this.selectionChangeSupport = new SelectionChangeSupport(eventSource);
        this.selectionChangeMulticaster = new SelectionChangeMulticaster();
        this.selectionContext = null;
        this.selection = Selection.EMPTY;
        this.clipboard = GraphicsEnvironment.isHeadless() ? new Clipboard("HeadlessClipboard") : Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    @Override
    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    @Override
    public SelectionContext getSelectionContext() {
        return this.selectionContext;
    }

    @Override
    public void setSelectionContext(SelectionContext newSelectionContext) {
        SelectionContext oldSelectionContext = this.selectionContext;
        Selection oldSelection = this.selection;
        if (oldSelectionContext != newSelectionContext) {
            if (oldSelectionContext != null) {
                oldSelectionContext.removeSelectionChangeListener(this.selectionChangeMulticaster);
            }
            Selection newSelection = newSelectionContext != null ? newSelectionContext.getSelection() : Selection.EMPTY;
            boolean selectionChange = !oldSelection.equals(newSelection);
            this.selectionContext = newSelectionContext;
            this.selection = newSelection;
            SelectionChangeEvent changeEvent = this.selectionChangeSupport.createEvent(this.selectionContext, this.selection);
            this.selectionChangeSupport.fireSelectionContextChange(changeEvent);
            if (selectionChange) {
                this.selectionChangeSupport.fireSelectionChange(changeEvent);
            }
            if (this.selectionContext != null) {
                this.selectionContext.addSelectionChangeListener(this.selectionChangeMulticaster);
            }
        }
    }

    @Override
    public Selection getSelection() {
        return this.selection;
    }

    @Override
    public void addSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionChangeSupport.addSelectionChangeListener(listener);
    }

    @Override
    public void removeSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionChangeSupport.removeSelectionChangeListener(listener);
    }

    @Override
    public SelectionChangeListener[] getSelectionChangeListeners() {
        return this.selectionChangeSupport.getSelectionChangeListeners();
    }

    private class SelectionChangeMulticaster
    implements SelectionChangeListener {
        private SelectionChangeMulticaster() {
        }

        @Override
        public void selectionChanged(SelectionChangeEvent event) {
            if (this.isAcceptedEvent(event)) {
                DefaultSelectionManager.this.selection = event.getSelection();
                DefaultSelectionManager.this.selectionChangeSupport.fireSelectionChange(event);
            }
        }

        @Override
        public void selectionContextChanged(SelectionChangeEvent event) {
            if (this.isAcceptedEvent(event)) {
                DefaultSelectionManager.this.selectionChangeSupport.fireSelectionContextChange(event);
            }
        }

        private boolean isAcceptedEvent(SelectionChangeEvent event) {
            return event.getSelectionContext() == DefaultSelectionManager.this.getSelectionContext();
        }
    }
}

