/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.selection.support;

import com.bc.ceres.swing.selection.AbstractSelectionContext;
import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.support.DefaultSelection;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;

public class ComboBoxSelectionContext
extends AbstractSelectionContext {
    private final ItemListener listSelectionListener = new ComboBoxSelectionHandler();
    private JComboBox comboBox;

    public ComboBoxSelectionContext(JComboBox comboBox) {
        this.comboBox = comboBox;
        this.comboBox.addItemListener(this.listSelectionListener);
    }

    @Override
    public Selection getSelection() {
        if (this.comboBox.getSelectedIndex() == -1) {
            return DefaultSelection.EMPTY;
        }
        return new DefaultSelection<Object>(this.comboBox.getSelectedItem());
    }

    @Override
    public void setSelection(Selection selection) {
        this.comboBox.setSelectedItem(selection.getSelectedValue());
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(JComboBox comboBox) {
        if (comboBox != this.comboBox) {
            this.comboBox.removeItemListener(this.listSelectionListener);
            this.comboBox = comboBox;
            this.comboBox.addItemListener(this.listSelectionListener);
            this.fireSelectionChange(this.getSelection());
        }
    }

    private class ComboBoxSelectionHandler
    implements ItemListener {
        private ComboBoxSelectionHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ComboBoxSelectionContext.this.fireSelectionChange(ComboBoxSelectionContext.this.getSelection());
        }
    }
}

