/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.progress;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.DialogProgressMonitor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingWorker;

public abstract class ProgressMonitorSwingWorker<T, V>
extends SwingWorker<T, V> {
    private CountDownLatch unBlock = new CountDownLatch(0);
    private final DialogProgressMonitor dialogPM;
    private Window blockingWindow;

    protected ProgressMonitorSwingWorker(Component parentComponent, String title) {
        this.dialogPM = new DialogProgressMonitor(parentComponent, title, Dialog.ModalityType.MODELESS);
    }

    @Override
    protected final T doInBackground() throws Exception {
        T value;
        try {
            value = this.doInBackground(this.dialogPM);
        }
        finally {
            this.dialogPM.done();
            this.unBlock.await();
            this.unblock();
        }
        return value;
    }

    protected abstract T doInBackground(ProgressMonitor var1) throws Exception;

    public final void executeWithBlocking() {
        this.unBlock = new CountDownLatch(1);
        this.blockingWindow = ProgressMonitorSwingWorker.createBlockingWindow();
        this.blockingWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ProgressMonitorSwingWorker.this.unBlock.countDown();
            }
        });
        this.dialogPM.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.execute();
        this.block();
    }

    private void block() {
        this.blockingWindow.setVisible(true);
    }

    private void unblock() {
        if (this.blockingWindow != null) {
            this.blockingWindow.dispose();
        }
    }

    private static Window createBlockingWindow() {
        Dialog window = new Dialog((Frame)null);
        window.setUndecorated(true);
        window.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        window.setBounds(0, 0, 0, 0);
        window.setFocusableWindowState(false);
        return window;
    }
}

