/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.swing.figure.AbstractHandle;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureStyle;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ScaleHandle
extends AbstractHandle {
    public static final int E = 0;
    public static final int NE = 1;
    public static final int N = 2;
    public static final int NW = 3;
    public static final int W = 4;
    public static final int SW = 5;
    public static final int S = 6;
    public static final int SE = 7;
    private static final int[] OPPONENT_INDEX = new int[]{4, 5, 6, 7, 0, 1, 2, 3};
    private static final int[] CURSOR_TYPES = new int[]{11, 7, 8, 6, 10, 4, 9, 5};
    private static final Point2D[] DIRECTIONS = new Point2D[]{new Point2D.Double(1.0, 0.0), new Point2D.Double(1.0, 1.0), new Point2D.Double(0.0, 1.0), new Point2D.Double(-1.0, 1.0), new Point2D.Double(-1.0, 0.0), new Point2D.Double(-1.0, -1.0), new Point2D.Double(0.0, -1.0), new Point2D.Double(1.0, -1.0)};
    private static final Point2D[] POSITIONS = new Point2D[]{new Point2D.Double(1.0, 0.5), new Point2D.Double(1.0, 0.0), new Point2D.Double(0.5, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.5), new Point2D.Double(0.0, 1.0), new Point2D.Double(0.5, 1.0), new Point2D.Double(1.0, 1.0)};
    private final int type;

    public ScaleHandle(Figure figure, int type, double dx, double dy, FigureStyle style) {
        super(figure, style, style);
        this.type = type;
        this.setShape(ScaleHandle.createHandleShape(dx, dy));
        this.updateLocation();
    }

    @Override
    public void updateLocation() {
        Point2D.Double point = this.getRefPoint(this.type);
        this.setLocation(point.getX(), point.getY());
    }

    @Override
    public void move(double dx, double dy) {
        this.setLocation(this.getX() + dx, this.getY() + dy);
        Rectangle2D bounds = this.getFigure().getBounds();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        double sx = (w + (dx *= DIRECTIONS[this.type].getX())) / w;
        double sy = (h + (dy *= -DIRECTIONS[this.type].getY())) / h;
        this.getFigure().scale(this.getRefPoint(OPPONENT_INDEX[this.type]), sx, sy);
    }

    @Override
    public Cursor getCursor() {
        double b;
        double n;
        double c;
        int index;
        double rotation = 0.0;
        if (rotation == 0.0) {
            return Cursor.getPredefinedCursor(CURSOR_TYPES[this.type]);
        }
        Point2D direction = DIRECTIONS[this.type];
        double a = Math.atan2(direction.getY(), direction.getX());
        if (a < 0.0) {
            a = Math.PI * 2 - a;
        }
        if ((index = (int)(c = (n = (double)CURSOR_TYPES.length) * (b = 0.5 * a / Math.PI) + 0.5 * (1.0 / n))) >= CURSOR_TYPES.length) {
            index = CURSOR_TYPES.length - 1;
        }
        return Cursor.getPredefinedCursor(CURSOR_TYPES[index]);
    }

    private Point2D.Double getRefPoint() {
        return this.getRefPoint(this.type);
    }

    private Point2D.Double getRefPoint(int type) {
        Rectangle2D bounds = this.getFigure().getBounds();
        double x = bounds.getX();
        double y = bounds.getY();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        return new Point2D.Double(x + POSITIONS[type].getX() * w, y + POSITIONS[type].getY() * h);
    }

    private static Shape createHandleShape(double dx, double dy) {
        return new Rectangle2D.Double(dx - 4.0, dy - 4.0, 8.0, 8.0);
    }
}

