/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.core.Assert;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.Symbol;
import com.bc.ceres.swing.figure.support.PointSymbol;
import com.bc.ceres.swing.figure.support.ShapeSymbol;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class NamedSymbol
implements Symbol {
    public static final NamedSymbol PLUS = new NamedSymbol("plus", PointSymbol.createPlus(14.0));
    public static final NamedSymbol CROSS = new NamedSymbol("cross", PointSymbol.createCross(14.0));
    public static final NamedSymbol STAR = new NamedSymbol("star", PointSymbol.createStar(14.0));
    public static final NamedSymbol SQUARE = new NamedSymbol("square", ShapeSymbol.createSquare(14.0));
    public static final NamedSymbol CIRCLE = new NamedSymbol("circle", ShapeSymbol.createCircle(14.0));
    public static final NamedSymbol PIN = new NamedSymbol("pin", ShapeSymbol.createPin(24.0));
    private static final Map<String, NamedSymbol> symbols = NamedSymbol.getDeclaredSymbols();
    private final String name;
    private final Symbol symbol;

    public static NamedSymbol getSymbol(String name) {
        return symbols.get(name.toLowerCase());
    }

    public NamedSymbol(String name, Symbol symbol) {
        Assert.notNull((Object)name, (String)"name");
        Assert.notNull((Object)symbol, (String)"symbol");
        this.name = name;
        this.symbol = symbol;
    }

    public String getName() {
        return this.name;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    @Override
    public boolean isHitBy(double x, double y) {
        return this.symbol.isHitBy(x, y);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.symbol.getBounds();
    }

    @Override
    public void draw(Rendering rendering, FigureStyle style) {
        this.symbol.draw(rendering, style);
    }

    public String toString() {
        return this.getName();
    }

    private static Map<String, NamedSymbol> getDeclaredSymbols() {
        Field[] declaredFields;
        HashMap<String, NamedSymbol> symbols = new HashMap<String, NamedSymbol>();
        for (Field declaredField : declaredFields = NamedSymbol.class.getDeclaredFields()) {
            NamedSymbol symbol;
            int modifiers = declaredField.getModifiers();
            if (!Symbol.class.isAssignableFrom(declaredField.getType()) || !Modifier.isPublic(modifiers) || !Modifier.isFinal(modifiers) || !Modifier.isStatic(modifiers)) continue;
            try {
                symbol = (NamedSymbol)declaredField.get(null);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            symbols.put(symbol.getName(), symbol);
        }
        return symbols;
    }
}

