/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.core.Assert;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.Symbol;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;

public class ImageSymbol
implements Symbol {
    private static final Color BGCOLOR = new Color(0, 0, 0, 0);
    private final String resourcePath;
    private final BufferedImage image;
    private final double refX;
    private final double refY;

    public static ImageSymbol createIcon(String imageResourcePath) {
        return ImageSymbol.createIcon(imageResourcePath, ImageSymbol.class);
    }

    public static ImageSymbol createIcon(String imageResourcePath, Class callerClass) {
        BufferedImage image = ImageSymbol.loadBufferedImage(imageResourcePath, callerClass);
        return new ImageSymbol(imageResourcePath, image, 0.5 * (double)image.getWidth(), 0.5 * (double)image.getHeight());
    }

    public static ImageSymbol createIcon(String imageResourcePath, double refX, double refY) {
        return ImageSymbol.createIcon(imageResourcePath, refX, refY, ImageSymbol.class);
    }

    public static ImageSymbol createIcon(String imageResourcePath, double refX, double refY, Class callerClass) {
        BufferedImage image = ImageSymbol.loadBufferedImage(imageResourcePath, callerClass);
        return new ImageSymbol(imageResourcePath, image, refX, refY);
    }

    private ImageSymbol(String resourcePath, BufferedImage image, double refX, double refY) {
        this.resourcePath = resourcePath;
        this.image = image;
        this.refX = refX;
        this.refY = refY;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public double getRefX() {
        return this.refX;
    }

    public double getRefY() {
        return this.refY;
    }

    @Override
    public void draw(Rendering rendering, FigureStyle style) {
        try {
            rendering.getGraphics().translate(-this.refX, -this.refY);
            rendering.getGraphics().drawRenderedImage(this.image, null);
        }
        finally {
            rendering.getGraphics().translate(this.refX, this.refY);
        }
    }

    @Override
    public boolean isHitBy(double x, double y) {
        int ix = (int)Math.round(x + this.refX);
        int iy = (int)Math.round(y + this.refY);
        return ix >= 0 && ix < this.image.getWidth() && iy >= 0 && iy < this.image.getHeight() && (this.image.getRGB(ix, iy) & 0xFF000000) != 0;
    }

    @Override
    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(-this.refX, -this.refY, this.image.getWidth(), this.image.getHeight());
    }

    private static BufferedImage loadBufferedImage(String imageResourcePath, Class callerClass) {
        URL resource = callerClass.getResource(imageResourcePath);
        Assert.argument((resource != null ? 1 : 0) != 0, (String)("imageResourcePath: resource not found: " + imageResourcePath));
        ImageIcon imageIcon = new ImageIcon(resource);
        BufferedImage image = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
        Graphics2D graphics = image.createGraphics();
        graphics.drawImage(imageIcon.getImage(), 0, 0, BGCOLOR, imageIcon.getImageObserver());
        graphics.dispose();
        return image;
    }
}

