/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import java.awt.Color;

public class CssColorConverter
implements Converter<Color> {
    public Class<? extends Color> getValueType() {
        return Color.class;
    }

    public Color parse(String text) throws ConversionException {
        try {
            boolean isCommaSeparatedColorValue;
            String[] rgbValues = text.split(",");
            boolean bl = isCommaSeparatedColorValue = rgbValues.length == 3;
            if (isCommaSeparatedColorValue) {
                return new Color(Integer.parseInt(rgbValues[0]), Integer.parseInt(rgbValues[1]), Integer.parseInt(rgbValues[2]));
            }
            return Color.decode("0x" + (text.startsWith("#") ? text.substring(1) : text));
        }
        catch (NumberFormatException e) {
            throw new ConversionException((Throwable)e);
        }
    }

    public String format(Color value) {
        StringBuilder sb = new StringBuilder("#");
        this.append2DigitHex(sb, value.getRed());
        this.append2DigitHex(sb, value.getGreen());
        this.append2DigitHex(sb, value.getBlue());
        return sb.toString();
    }

    private void append2DigitHex(StringBuilder sb, int red) {
        String s = Integer.toHexString(red);
        if (s.length() == 1) {
            sb.append("0");
            sb.append(s);
        } else if (s.length() == 2) {
            sb.append(s);
        } else {
            sb.append("00");
        }
    }
}

