/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.interactions;

import com.bc.ceres.swing.figure.FigureEditor;
import com.bc.ceres.swing.figure.FigureEditorInteractor;
import com.bc.ceres.swing.figure.ShapeFigure;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;

public abstract class InsertRectangularFigureInteractor
extends FigureEditorInteractor {
    private Point referencePoint;
    private boolean canceled;
    private ShapeFigure figure;
    private RectangularShape rectangularShape;
    private boolean started;

    protected abstract RectangularShape createRectangularShape(Point2D var1);

    @Override
    public void cancelInteraction(InputEvent event) {
        if (!this.canceled) {
            this.canceled = true;
            this.getFigureEditor(event).getFigureSelection().removeAllFigures();
            this.getFigureEditor(event).getFigureCollection().removeFigure(this.figure);
            super.cancelInteraction(event);
        }
    }

    @Override
    protected void stopInteraction(InputEvent inputEvent) {
        super.stopInteraction(inputEvent);
        this.started = false;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.started = this.startInteraction(event);
        if (this.started) {
            FigureEditor figureEditor = this.getFigureEditor(event);
            figureEditor.getFigureSelection().removeAllFigures();
            this.referencePoint = event.getPoint();
            this.canceled = false;
            this.rectangularShape = this.createRectangularShape(this.referencePoint);
            this.figure = figureEditor.getFigureFactory().createPolygonFigure(this.toModelShape(event, this.rectangularShape), figureEditor.getDefaultPolygonStyle());
            if (this.figure != null) {
                figureEditor.getFigureCollection().addFigure(this.figure);
            } else {
                this.stopInteraction(event);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.started) {
            FigureEditor figureEditor = this.getFigureEditor(event);
            if (this.rectangularShape.isEmpty()) {
                figureEditor.getFigureCollection().removeFigure(this.figure);
            } else {
                figureEditor.insertFigures(false, this.figure);
            }
            this.stopInteraction(event);
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.started) {
            int width = event.getX() - this.referencePoint.x;
            int height = event.getY() - this.referencePoint.y;
            int x = this.referencePoint.x;
            int y = this.referencePoint.y;
            if (width < 0) {
                x -= (width *= -1);
            }
            if (height < 0) {
                y -= (height *= -1);
            }
            this.rectangularShape.setFrame(x, y, width, height);
            this.figure.setShape(this.getViewToModelTransform(event).createTransformedShape(this.rectangularShape));
        }
    }
}

