/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure;

import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.swing.figure.AbstractFigure;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.PointFigure;
import com.bc.ceres.swing.figure.Symbol;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import com.bc.ceres.swing.figure.support.NamedSymbol;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class AbstractPointFigure
extends AbstractFigure
implements PointFigure {
    protected AbstractPointFigure(FigureStyle normalStyle, FigureStyle selectedStyle) {
        super(normalStyle, selectedStyle);
    }

    @Override
    public Symbol getSymbol() {
        Symbol symbol = this.getNormalStyle().getSymbol();
        if (symbol != null) {
            return symbol;
        }
        return NamedSymbol.CROSS;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public Point2D getLocation() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    @Override
    public void setLocation(Point2D location) {
        this.setLocation(location.getX(), location.getY());
    }

    public abstract void setLocation(double var1, double var3);

    public abstract double getRadius();

    @Override
    public final Figure.Rank getRank() {
        return Figure.Rank.POINT;
    }

    @Override
    public void scale(Point2D point, double sx, double sy) {
        double x0 = point.getX();
        double y0 = point.getY();
        this.setLocation(x0 + (this.getX() - x0) * sx, y0 + (this.getY() - y0) * sy);
    }

    @Override
    public void rotate(Point2D point, double theta) {
        AffineTransform transform = new AffineTransform();
        transform.rotate(theta, point.getX(), point.getY());
        Point2D point2D = transform.transform(this.getLocation(), null);
        this.setLocation(point2D);
    }

    @Override
    public void move(double dx, double dy) {
        this.setLocation(this.getX() + dx, this.getY() + dy);
    }

    @Override
    public Rectangle2D getBounds() {
        double r = this.getRadius();
        return new Rectangle2D.Double(this.getX() - r, this.getY() - r, 2.0 * r, 2.0 * r);
    }

    @Override
    public boolean isCloseTo(Point2D point, AffineTransform m2v) {
        double r;
        double dy;
        double dx = point.getX() - this.getX();
        if (dx * dx + (dy = point.getY() - this.getY()) * dy < (r = this.getRadius()) * r) {
            return true;
        }
        Symbol symbol = this.getSymbol();
        if (symbol == null) {
            return false;
        }
        Point2D locationInView = m2v.transform(this.getLocation(), null);
        Point2D pointInView = m2v.transform(point, null);
        return symbol.isHitBy(pointInView.getX() - locationInView.getX(), pointInView.getY() - locationInView.getY());
    }

    @Override
    public FigureStyle getEffectiveStyle() {
        if (this.isSelected()) {
            DefaultFigureStyle style = new DefaultFigureStyle(this.getNormalStyle());
            return style;
        }
        return this.getNormalStyle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void draw(Rendering rendering) {
        Viewport vp = rendering.getViewport();
        AffineTransform m2v = vp.getModelToViewTransform();
        Point2D locationInView = m2v.transform(this.getLocation(), null);
        if (!Double.isNaN(locationInView.getX()) && !Double.isNaN(locationInView.getY())) {
            Graphics2D g = rendering.getGraphics();
            try {
                g.translate(locationInView.getX(), locationInView.getY());
                this.drawPoint(rendering);
            }
            finally {
                g.translate(-locationInView.getX(), -locationInView.getY());
            }
        }
    }

    protected void drawPoint(Rendering rendering) {
        this.getSymbol().draw(rendering, this.getEffectiveStyle());
    }
}

