/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.demo;

import com.bc.ceres.swing.actions.CopyAction;
import com.bc.ceres.swing.actions.CutAction;
import com.bc.ceres.swing.actions.DeleteAction;
import com.bc.ceres.swing.actions.PasteAction;
import com.bc.ceres.swing.actions.RedoAction;
import com.bc.ceres.swing.actions.SelectAllAction;
import com.bc.ceres.swing.actions.UndoAction;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionManager;
import com.bc.ceres.swing.selection.support.DefaultSelectionManager;
import com.bc.ceres.swing.selection.support.ListSelectionContext;
import com.bc.ceres.swing.undo.support.DefaultUndoContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public class MultiSelectionSourceApp {
    private final DefaultSelectionManager selectionManager;
    private JFrame frame;
    private JDialog dialog1;
    private JDialog dialog2;
    private JDialog dialog3;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private DeleteAction deleteAction;
    private SelectAllAction selectAllAction;
    private CutAction cutAction;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    private Action[] actions;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Locale.setDefault(Locale.ENGLISH);
        MultiSelectionSourceApp drawingApp = new MultiSelectionSourceApp();
        drawingApp.startUp();
    }

    public MultiSelectionSourceApp() {
        DefaultUndoContext undoContext = new DefaultUndoContext(this);
        this.undoAction = new UndoAction(undoContext);
        this.selectionManager = new DefaultSelectionManager(this);
        this.redoAction = new RedoAction(undoContext);
        this.cutAction = new CutAction(this.selectionManager);
        this.copyAction = new CopyAction(this.selectionManager);
        this.pasteAction = new PasteAction(this.selectionManager);
        this.selectAllAction = new SelectAllAction(this.selectionManager);
        this.deleteAction = new DeleteAction(this.selectionManager);
        this.actions = new Action[]{this.undoAction, this.redoAction, this.cutAction, this.copyAction, this.pasteAction, this.selectAllAction, this.deleteAction};
        this.frame = new MyFrame();
        this.frame.setDefaultCloseOperation(3);
        this.dialog1 = this.createDialog("Context 1", new String[]{"die Gegenauslese", "die Abgrenzung", "die Anwahl", "die Auslese", "die Aussonderung", "das Aussortieren", "die Auswahl", "die Kollektion", "die Markierung", "die Selektierung", "die Selektion", "das Sortiment", "die Trennwirkung", "die Wahl", "der Wahlschalter"});
        this.dialog2 = this.createDialog("Context 2", new String[]{"die Gefahr", "das Risiko  Pl.: die Risiken", "das Versicherungsrisiko", "das Wagnis", "das Maximalblatt", "die Gesamtversicherung", "Versicherung gegen alle Risiken", "hochgef\u00e4hrlich"});
        this.dialog3 = this.createDialog("Context 3", new String[]{"abzetteln", "annullieren", "aufbinden", "aufknoten", "aufmachen", "l\u00f6schen", "l\u00f6sen", "r\u00fccksetzen", "trennen"});
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createViewMenu());
        menuBar.setFocusable(false);
        this.frame.setJMenuBar(menuBar);
        String[] listContent = new String[]{"roster die Dienstliste", "roster der Dienstplan", "roster die Liste", "roster das Mitgliedsverzeichnis", "duty-roster der Dienstplan", "duty roster der Dienstplan", "membership roster die Mitgliederliste", "membership roster das Mitgliedsbuch", "personnel roster die Stammrolle", "staff roster die Diensteinteilung", "staff roster [tech.] der Dienstplan", "duty roster turn [tech.] die Diensteinteilung", "rolling stock roster [tech.] der Dienstplan"};
        MyPageComponent pageComponent = new MyPageComponent(this.frame, listContent);
        JComponent control = pageComponent.createControl(this);
        this.frame.add((Component)control, "Center");
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
                String message = MessageFormat.format("An internal error occurred!\nType: {0}\nMessage: {1}", e.getClass(), e.getMessage());
                JOptionPane.showMessageDialog(MultiSelectionSourceApp.this.frame, message, "Internal Error", 0);
                System.exit(1);
            }
        });
        this.getSelectionManager().addSelectionChangeListener(new SelectionChangeListener(){

            @Override
            public void selectionChanged(SelectionChangeEvent event) {
                System.out.println("appContext: selection change: " + event.getSelection());
            }

            @Override
            public void selectionContextChanged(SelectionChangeEvent event) {
                System.out.println("appContext: selection context change: " + event.getSelection());
            }
        });
        undoContext.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent event) {
                System.out.println("appContext: edit happened: " + event.getEdit());
            }
        });
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public void bindEditKeys(JComponent component) {
        for (Action action : this.actions) {
            Object value = action.getValue("AcceleratorKey");
            if (!(value instanceof KeyStroke)) continue;
            Object actionId = action.getValue("ActionCommandKey");
            component.getInputMap().put((KeyStroke)value, actionId);
            component.getActionMap().put(actionId, action);
        }
    }

    private void startUp() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultiSelectionSourceApp.this.frame.pack();
                MultiSelectionSourceApp.this.frame.setLocation(50, 50);
                MultiSelectionSourceApp.this.frame.setVisible(true);
                MultiSelectionSourceApp.this.dialog1.pack();
                MultiSelectionSourceApp.this.dialog1.setLocation(MultiSelectionSourceApp.this.frame.getX() + MultiSelectionSourceApp.this.frame.getWidth(), MultiSelectionSourceApp.this.frame.getY());
                MultiSelectionSourceApp.this.dialog1.setVisible(true);
                MultiSelectionSourceApp.this.dialog2.pack();
                MultiSelectionSourceApp.this.dialog2.setLocation(MultiSelectionSourceApp.this.dialog1.getX() + MultiSelectionSourceApp.this.dialog1.getWidth(), MultiSelectionSourceApp.this.dialog1.getY());
                MultiSelectionSourceApp.this.dialog2.setVisible(true);
                MultiSelectionSourceApp.this.dialog3.pack();
                MultiSelectionSourceApp.this.dialog3.setLocation(MultiSelectionSourceApp.this.dialog2.getX() + MultiSelectionSourceApp.this.dialog2.getWidth(), MultiSelectionSourceApp.this.dialog2.getY());
                MultiSelectionSourceApp.this.dialog3.setVisible(true);
            }
        });
    }

    private JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        menu.add(new ExitAction());
        return menu;
    }

    private JMenu createEditMenu() {
        JMenu menu = new JMenu("Edit");
        menu.add(this.undoAction);
        menu.add(this.redoAction);
        menu.addSeparator();
        menu.add(this.cutAction);
        menu.add(this.copyAction);
        menu.add(this.pasteAction);
        menu.addSeparator();
        menu.add(this.selectAllAction);
        menu.addSeparator();
        menu.add(this.deleteAction);
        return menu;
    }

    private JMenu createViewMenu() {
        JMenu menu = new JMenu("View");
        menu.add(new ViewAction(this.dialog1));
        menu.add(new ViewAction(this.dialog2));
        menu.add(new ViewAction(this.dialog3));
        return menu;
    }

    private JDialog createDialog(String title, String[] listContent) {
        JDialog dialog = new JDialog(this.frame, title, false);
        MyPageComponent myPageComponent = new MyPageComponent(dialog, listContent);
        dialog.setDefaultCloseOperation(2);
        dialog.setContentPane(myPageComponent.createControl(this));
        return dialog;
    }

    private static class MyPageComponent
    implements PageComponent {
        private MultiSelectionSourceApp appContext;
        private final String[] listContent;
        private ListSelectionContext selectionContext;

        public MyPageComponent(Window window, String[] listContent) {
            this.listContent = listContent;
            window.setFocusable(true);
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    this.windowActivated();
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                    this.windowDeactivated();
                }

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    System.out.println("e = " + e);
                    this.windowActivated();
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    System.out.println("e = " + e);
                    this.windowDeactivated();
                }
            });
        }

        @Override
        public JComponent createControl(MultiSelectionSourceApp appContext) {
            this.appContext = appContext;
            DefaultListModel<String> listModel = new DefaultListModel<String>();
            for (String item : this.listContent) {
                listModel.addElement(item);
            }
            JList list = new JList(listModel);
            this.selectionContext = new ListSelectionContext(list);
            appContext.bindEditKeys(list);
            JScrollPane scrollPane = new JScrollPane(list);
            JPanel panel = new JPanel(new BorderLayout(3, 3));
            panel.setBorder(new EmptyBorder(3, 3, 3, 3));
            panel.add((Component)scrollPane, "Center");
            return panel;
        }

        @Override
        public void windowActivated() {
            this.appContext.getSelectionManager().setSelectionContext(this.selectionContext);
        }

        @Override
        public void windowDeactivated() {
        }
    }

    private class MyFrame
    extends JFrame {
        public MyFrame() throws HeadlessException {
            super(MultiSelectionSourceApp.this.getClass().getSimpleName());
        }
    }

    private static class ViewAction
    extends AbstractAction {
        private final JDialog dialog;

        public ViewAction(JDialog dialog) {
            this.dialog = dialog;
            this.putValue("Name", dialog.getTitle());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.dialog.setVisible(true);
        }
    }

    private class ExitAction
    extends AbstractAction {
        private ExitAction() {
            this.putValue("Name", "Exit");
            this.putValue("ActionCommandKey", this.getClass().getName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiSelectionSourceApp.this.frame.dispose();
        }
    }

    public static interface PageComponent {
        public JComponent createControl(MultiSelectionSourceApp var1);

        public void windowActivated();

        public void windowDeactivated();
    }
}

