/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding.internal;

import com.bc.ceres.binding.BindingException;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.binding.ComponentAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListSelectionAdapter
extends ComponentAdapter
implements ListSelectionListener,
PropertyChangeListener {
    private final JList list;

    public ListSelectionAdapter(JList list) {
        this.list = list;
    }

    @Override
    public JComponent[] getComponents() {
        return new JComponent[]{this.list};
    }

    @Override
    public void bindComponents() {
        this.updateListModel();
        this.getValueDescriptor().addAttributeChangeListener((PropertyChangeListener)this);
        this.list.addListSelectionListener(this);
    }

    @Override
    public void unbindComponents() {
        this.getValueDescriptor().removeAttributeChangeListener((PropertyChangeListener)this);
        this.list.removeListSelectionListener(this);
    }

    @Override
    public void adjustComponents() {
        Object array = this.getBinding().getPropertyValue();
        if (array != null) {
            ListModel model = this.list.getModel();
            int size = model.getSize();
            int[] temp = new int[size];
            int numSelectedElements = 0;
            int arrayLength = Array.getLength(array);
            for (int i = 0; i < size; ++i) {
                Object element = model.getElementAt(i);
                for (int j = 0; j < arrayLength; ++j) {
                    if (!element.equals(Array.get(array, j))) continue;
                    temp[numSelectedElements++] = i;
                }
            }
            int[] indices = new int[numSelectedElements];
            System.arraycopy(temp, 0, indices, 0, numSelectedElements);
            this.list.setSelectedIndices(indices);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.getValueDescriptor() && evt.getPropertyName().equals("valueSet")) {
            this.updateListModel();
        }
    }

    private PropertyDescriptor getValueDescriptor() {
        return this.getBinding().getContext().getPropertySet().getDescriptor(this.getBinding().getPropertyName());
    }

    private void updateListModel() {
        ValueSet valueSet = this.getValueDescriptor().getValueSet();
        if (valueSet != null) {
            Object oldElems = this.getBinding().getPropertyValue();
            this.list.setListData(valueSet.getItems());
            if (oldElems != null) {
                ListSelectionModel selectionModel = this.list.getSelectionModel();
                int arrayLength = Array.getLength(oldElems);
                ListModel listModel = this.list.getModel();
                for (int i = 0; i < listModel.getSize(); ++i) {
                    Object element = listModel.getElementAt(i);
                    for (int j = 0; j < arrayLength; ++j) {
                        if (!element.equals(Array.get(oldElems, j))) continue;
                        selectionModel.addSelectionInterval(i, i);
                    }
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        if (this.getBinding().isAdjustingComponents()) {
            return;
        }
        Property model = this.getBinding().getContext().getPropertySet().getProperty(this.getBinding().getPropertyName());
        Object[] selectedValues = this.list.getSelectedValues();
        Object array = Array.newInstance(model.getDescriptor().getType().getComponentType(), selectedValues.length);
        for (int i = 0; i < selectedValues.length; ++i) {
            Array.set(array, i, selectedValues[i]);
        }
        try {
            model.setValue(array);
            this.getBinding().clearProblem();
        }
        catch (ValidationException e) {
            this.getBinding().reportProblem((BindingException)e);
        }
    }
}

