/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding.internal;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.binding.ComponentAdapter;
import com.bc.ceres.swing.binding.internal.TextComponentAdapter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class ComboBoxAdapter
extends ComponentAdapter
implements ActionListener,
PropertyChangeListener {
    private final JComboBox comboBox;
    private TextComponentAdapter textComponentAdapter;

    public ComboBoxAdapter(JComboBox comboBox) {
        this.comboBox = comboBox;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.adjustProperty();
    }

    @Override
    public void bindComponents() {
        this.adjustComboBoxModel();
        this.adjustTextComponent();
        this.getValueDescriptor().addAttributeChangeListener((PropertyChangeListener)this);
        this.comboBox.addPropertyChangeListener("editable", this);
        this.comboBox.addActionListener(this);
    }

    @Override
    public void unbindComponents() {
        this.comboBox.removeActionListener(this);
        this.comboBox.removePropertyChangeListener("editable", this);
        this.getValueDescriptor().removeAttributeChangeListener((PropertyChangeListener)this);
        this.unbindTextComponent();
    }

    @Override
    public void adjustComponents() {
        Object value = this.getBinding().getPropertyValue();
        this.comboBox.setSelectedItem(value);
    }

    @Override
    public JComponent[] getComponents() {
        return new JComponent[]{this.comboBox};
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.getValueDescriptor() && "valueSet".equals(evt.getPropertyName())) {
            this.adjustComboBoxModel();
        }
        if (evt.getSource() == this.comboBox && "editable".equals(evt.getPropertyName())) {
            this.adjustTextComponent();
        }
    }

    private PropertyDescriptor getValueDescriptor() {
        return this.getBinding().getContext().getPropertySet().getDescriptor(this.getBinding().getPropertyName());
    }

    private void adjustComboBoxModel() {
        ValueSet valueSet = this.getValueDescriptor().getValueSet();
        if (valueSet != null) {
            Object oldValue = this.getBinding().getPropertyValue();
            this.comboBox.setModel(new DefaultComboBoxModel<Object>(valueSet.getItems()));
            this.comboBox.setSelectedItem(oldValue);
            this.adjustProperty();
        }
    }

    private void adjustProperty() {
        this.getBinding().setPropertyValue(this.comboBox.getSelectedItem());
    }

    private void adjustTextComponent() {
        Component editorComponent = this.comboBox.getEditor().getEditorComponent();
        if (this.comboBox.isEditable() && editorComponent instanceof JTextComponent) {
            this.bindTextComponent((JTextComponent)editorComponent);
        } else {
            this.unbindTextComponent();
        }
    }

    private void bindTextComponent(JTextComponent editorComponent) {
        this.textComponentAdapter = new TextComponentAdapter(editorComponent);
        this.textComponentAdapter.setBinding(this.getBinding());
        this.textComponentAdapter.bindComponents();
    }

    private void unbindTextComponent() {
        if (this.textComponentAdapter != null) {
            this.textComponentAdapter.unbindComponents();
            this.textComponentAdapter.setBinding(null);
            this.textComponentAdapter = null;
        }
    }
}

