/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing;

import com.bc.ceres.core.Assert;
import com.bc.ceres.swing.Grid;
import com.bc.ceres.swing.GridSelectionModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ListControlBar
extends JToolBar {
    public static final String ID_ADD = "add";
    public static final String ID_REMOVE = "remove";
    public static final String ID_MOVE_UP = "moveUp";
    public static final String ID_MOVE_DOWN = "moveDown";
    private final Map<String, Action> actionMap;
    private ListModelAdapter listModelAdapter;

    public ListControlBar(int orientation, String ... actionIds) {
        super(orientation);
        this.setFloatable(false);
        if (actionIds == null || actionIds.length == 0) {
            actionIds = new String[]{ID_ADD, ID_REMOVE, ID_MOVE_UP, ID_MOVE_DOWN};
        }
        this.actionMap = new HashMap<String, Action>();
        for (String actionId : actionIds) {
            Action action = this.createAction(actionId);
            this.actionMap.put(action.getValue("ActionCommandKey").toString(), action);
            this.add(action);
        }
        this.updateState();
    }

    public ListModelAdapter getListModelAdapter() {
        return this.listModelAdapter;
    }

    public void setListModelAdapter(ListModelAdapter listModelAdapter) {
        Assert.notNull((Object)listModelAdapter, (String)"listModelAdapter");
        ListModelAdapter oldListModelAdapter = this.listModelAdapter;
        this.listModelAdapter = listModelAdapter;
        this.firePropertyChange("listModelAdapter", oldListModelAdapter, this.listModelAdapter);
        this.updateState();
    }

    public static ListControlBar create(int orientation, JList list, ListController listController, String ... actionIds) {
        ListControlBar listControlBar = new ListControlBar(orientation, actionIds);
        listControlBar.setListModelAdapter(new JListModelAdapter(listControlBar, list, listController));
        return listControlBar;
    }

    public static ListControlBar create(int orientation, JTable table, ListController listController, String ... actionIds) {
        ListControlBar listControlBar = new ListControlBar(orientation, actionIds);
        listControlBar.setListModelAdapter(new JTableModelAdapter(listControlBar, table, listController));
        return listControlBar;
    }

    public static ListControlBar create(int orientation, Grid grid, ListController listController, String ... actionIds) {
        ListControlBar listControlBar = new ListControlBar(orientation, actionIds);
        listControlBar.setListModelAdapter(new GridAdapter(listControlBar, grid, listController));
        return listControlBar;
    }

    public Action getAction(String actionId) {
        return this.actionMap.get(actionId);
    }

    public AbstractButton getActionComponent(String actionId) {
        Action action = this.getAction(actionId);
        return action != null ? this.getActionComponent(action) : null;
    }

    public AbstractButton getActionComponent(Action action) {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            AbstractButton abstractButton;
            if (!(component instanceof AbstractButton) || (abstractButton = (AbstractButton)component).getAction() != action) continue;
            return abstractButton;
        }
        return null;
    }

    protected Action createAction(String actionId) {
        switch (actionId) {
            case "add": {
                return new AddAction();
            }
            case "remove": {
                return new RemoveAction();
            }
            case "moveUp": {
                return new MoveUpAction();
            }
            case "moveDown": {
                return new MoveDownAction();
            }
        }
        throw new IllegalArgumentException("actionId");
    }

    public void addRow() {
        this.checkValidState();
        if (this.listModelAdapter.addRow(this.listModelAdapter.getMaxSelectedRowIndex())) {
            this.updateState();
        }
    }

    public void removeSelectedRows() {
        this.checkValidState();
        if (this.listModelAdapter.removeRows(this.listModelAdapter.getSelectedRowIndices())) {
            this.updateState();
        }
    }

    public void moveSelectedRowUp() {
        this.checkValidState();
        if (this.listModelAdapter.moveRowUp(this.listModelAdapter.getMinSelectedRowIndex())) {
            this.updateState();
        }
    }

    public void moveSelectedRowDown() {
        this.checkValidState();
        if (this.listModelAdapter.moveRowDown(this.listModelAdapter.getMaxSelectedRowIndex())) {
            this.updateState();
        }
    }

    public void updateState() {
        Action addAction = this.getAction(ID_ADD);
        Action removeAction = this.getAction(ID_REMOVE);
        Action moveUpAction = this.getAction(ID_MOVE_UP);
        Action moveDownAction = this.getAction(ID_MOVE_DOWN);
        if (this.listModelAdapter != null) {
            int[] selectedRowIndices = this.listModelAdapter.getSelectedRowIndices();
            int selectedRowCount = selectedRowIndices.length;
            if (addAction != null) {
                addAction.setEnabled(true);
            }
            if (removeAction != null) {
                removeAction.setEnabled(selectedRowCount > 0);
            }
            if (moveUpAction != null) {
                int minSelectionIndex = this.listModelAdapter.getMinSelectedRowIndex();
                moveUpAction.setEnabled(selectedRowCount == 1 && minSelectionIndex >= 0 && minSelectionIndex > 0);
            }
            if (moveDownAction != null) {
                int maxSelectionIndex = this.listModelAdapter.getMaxSelectedRowIndex();
                moveDownAction.setEnabled(selectedRowCount == 1 && maxSelectionIndex >= 0 && maxSelectionIndex < this.listModelAdapter.getRowCount() - 1);
            }
            this.listModelAdapter.updateState(this);
        } else {
            if (addAction != null) {
                addAction.setEnabled(false);
            }
            if (removeAction != null) {
                removeAction.setEnabled(false);
            }
            if (moveUpAction != null) {
                moveUpAction.setEnabled(false);
            }
            if (moveDownAction != null) {
                moveDownAction.setEnabled(false);
            }
        }
    }

    private void checkValidState() {
        Assert.state((this.listModelAdapter != null ? 1 : 0) != 0, (String)"listModelAdapter != null");
    }

    private static class GridAdapter
    extends AbstractListModelAdapter
    implements GridSelectionModel.Listener {
        private final ListControlBar listControlBar;
        private final Grid grid;

        public GridAdapter(ListControlBar listControlBar, Grid grid, ListController listController) {
            super(listController);
            this.listControlBar = listControlBar;
            this.grid = grid;
            this.installSelectionModelListener(null, grid.getSelectionModel());
            this.grid.addPropertyChangeListener("selectionModel", new SelectionModelChangeListener());
            this.updateState(listControlBar);
            this.grid.addPropertyChangeListener("showSelectionColumn", new ShowSelectionColumnChangeListener());
        }

        @Override
        public int getRowCount() {
            return this.grid.getDataRowCount();
        }

        @Override
        public int getMinSelectedRowIndex() {
            return this.grid.getSelectionModel().getMinSelectedRowIndex();
        }

        @Override
        public int getMaxSelectedRowIndex() {
            return this.grid.getSelectionModel().getMinSelectedRowIndex();
        }

        @Override
        public int[] getSelectedRowIndices() {
            return this.grid.getSelectionModel().getSelectedRowIndices();
        }

        @Override
        public void gridSelectionChanged(GridSelectionModel.Event event) {
            this.listControlBar.updateState();
        }

        @Override
        public void updateState(ListControlBar listControlBar) {
            super.updateState(listControlBar);
            this.hideActionIfSelectionRowInvisible(ListControlBar.ID_REMOVE);
            this.hideActionIfSelectionRowInvisible(ListControlBar.ID_MOVE_UP);
            this.hideActionIfSelectionRowInvisible(ListControlBar.ID_MOVE_DOWN);
        }

        private void hideActionIfSelectionRowInvisible(String actionId) {
            Action action = this.listControlBar.getAction(actionId);
            AbstractButton actionComponent = this.listControlBar.getActionComponent(action);
            actionComponent.setVisible(this.grid.getShowSelectionColumn());
        }

        private void installSelectionModelListener(GridSelectionModel oldModel, GridSelectionModel newModel) {
            if (oldModel != null) {
                oldModel.removeListener(this);
            }
            if (newModel != null) {
                newModel.addListener(this);
            }
        }

        private class ShowSelectionColumnChangeListener
        implements PropertyChangeListener {
            private ShowSelectionColumnChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GridAdapter.this.updateState(GridAdapter.this.listControlBar);
            }
        }

        private class SelectionModelChangeListener
        implements PropertyChangeListener {
            private SelectionModelChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GridSelectionModel oldModel = (GridSelectionModel)evt.getOldValue();
                GridSelectionModel newModel = (GridSelectionModel)evt.getNewValue();
                GridAdapter.this.installSelectionModelListener(oldModel, newModel);
            }
        }
    }

    private static class JTableModelAdapter
    extends AbstractListModelAdapter
    implements TableModelListener,
    ListSelectionListener {
        private final ListControlBar listControlBar;
        private final JTable table;

        public JTableModelAdapter(ListControlBar listControlBar, JTable table, ListController listController) {
            super(listController);
            this.listControlBar = listControlBar;
            this.table = table;
            this.installModelListener(null, table.getModel());
            this.installSelectionModelListener(null, table.getSelectionModel());
            this.table.addPropertyChangeListener("model", new ModelChangeListener());
            this.table.addPropertyChangeListener("selectionModel", new SelectionModelChangeListener());
        }

        @Override
        public int getRowCount() {
            return this.table.getModel().getRowCount();
        }

        @Override
        public int getMinSelectedRowIndex() {
            return this.table.getSelectionModel().getMinSelectionIndex();
        }

        @Override
        public int getMaxSelectedRowIndex() {
            return this.table.getSelectionModel().getMaxSelectionIndex();
        }

        @Override
        public int[] getSelectedRowIndices() {
            return this.table.getSelectedRows();
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.listControlBar.updateState();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.listControlBar.updateState();
        }

        private void installModelListener(TableModel oldModel, TableModel newModel) {
            if (oldModel != null) {
                oldModel.removeTableModelListener(this);
            }
            if (newModel != null) {
                newModel.addTableModelListener(this);
            }
        }

        private void installSelectionModelListener(ListSelectionModel oldModel, ListSelectionModel newModel) {
            if (oldModel != null) {
                oldModel.removeListSelectionListener(this);
            }
            if (newModel != null) {
                newModel.addListSelectionListener(this);
            }
        }

        private class SelectionModelChangeListener
        implements PropertyChangeListener {
            private SelectionModelChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ListSelectionModel oldModel = (ListSelectionModel)evt.getOldValue();
                ListSelectionModel newModel = (ListSelectionModel)evt.getNewValue();
                JTableModelAdapter.this.installSelectionModelListener(oldModel, newModel);
            }
        }

        private class ModelChangeListener
        implements PropertyChangeListener {
            private ModelChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableModel oldModel = (TableModel)evt.getOldValue();
                TableModel newModel = (TableModel)evt.getNewValue();
                JTableModelAdapter.this.installModelListener(oldModel, newModel);
            }
        }
    }

    private static class JListModelAdapter
    extends AbstractListModelAdapter
    implements ListDataListener,
    ListSelectionListener {
        private final ListControlBar listControlBar;
        private final JList list;

        public JListModelAdapter(ListControlBar listControlBar, JList list, ListController listController) {
            super(listController);
            this.listControlBar = listControlBar;
            this.list = list;
            this.list.addPropertyChangeListener("model", new ModelChangeListener());
            this.list.addListSelectionListener(this);
        }

        @Override
        public int getRowCount() {
            return this.list.getModel().getSize();
        }

        @Override
        public int getMinSelectedRowIndex() {
            return this.list.getMinSelectionIndex();
        }

        @Override
        public int getMaxSelectedRowIndex() {
            return this.list.getMaxSelectionIndex();
        }

        @Override
        public int[] getSelectedRowIndices() {
            return this.list.getSelectedIndices();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.listControlBar.updateState();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.listControlBar.updateState();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.listControlBar.updateState();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.listControlBar.updateState();
        }

        private void installModelListener(ListModel oldModel, ListModel newModel) {
            if (oldModel != null) {
                oldModel.removeListDataListener(this);
            }
            if (newModel != null) {
                newModel.addListDataListener(this);
            }
        }

        private class ModelChangeListener
        implements PropertyChangeListener {
            private ModelChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ListModel oldModel = (ListModel)evt.getOldValue();
                ListModel newModel = (ListModel)evt.getNewValue();
                JListModelAdapter.this.installModelListener(oldModel, newModel);
            }
        }
    }

    private static abstract class AbstractListModelAdapter
    implements ListModelAdapter {
        private final ListController controller;

        protected AbstractListModelAdapter(ListController controller) {
            this.controller = controller;
        }

        @Override
        public boolean addRow(int index) {
            return this.controller.addRow(index);
        }

        @Override
        public boolean removeRows(int[] indices) {
            return this.controller.removeRows(indices);
        }

        @Override
        public boolean moveRowUp(int index) {
            return this.controller.moveRowUp(index);
        }

        @Override
        public boolean moveRowDown(int index) {
            return this.controller.moveRowDown(index);
        }

        @Override
        public void updateState(ListControlBar listControlBar) {
            this.controller.updateState(listControlBar);
        }
    }

    public static interface ListModelAdapter
    extends ListController {
        public int getRowCount();

        public int getMinSelectedRowIndex();

        public int getMaxSelectedRowIndex();

        public int[] getSelectedRowIndices();
    }

    public static abstract class AbstractListController
    implements ListController {
        @Override
        public void updateState(ListControlBar listControlBar) {
        }
    }

    public static interface ListController {
        public boolean addRow(int var1);

        public boolean removeRows(int[] var1);

        public boolean moveRowUp(int var1);

        public boolean moveRowDown(int var1);

        public void updateState(ListControlBar var1);
    }

    private class MoveDownAction
    extends AbstractAction {
        private MoveDownAction() {
            this.putValue("ActionCommandKey", ListControlBar.ID_MOVE_DOWN);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/MoveDown16.gif")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ListControlBar.this.moveSelectedRowDown();
        }
    }

    private class MoveUpAction
    extends AbstractAction {
        private MoveUpAction() {
            this.putValue("ActionCommandKey", ListControlBar.ID_MOVE_UP);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/MoveUp16.gif")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ListControlBar.this.moveSelectedRowUp();
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private RemoveAction() {
            this.putValue("ActionCommandKey", ListControlBar.ID_REMOVE);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/Minus16.gif")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ListControlBar.this.removeSelectedRows();
        }
    }

    private class AddAction
    extends AbstractAction {
        private AddAction() {
            this.putValue("ActionCommandKey", ListControlBar.ID_ADD);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/Plus16.gif")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ListControlBar.this.addRow();
        }
    }
}

