/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class CollapsiblePane
extends JPanel {
    private static final Icon collapsedIcon = CollapsiblePane.createHeaderIcon(true);
    private static final Icon expandedIcon = CollapsiblePane.createHeaderIcon(false);
    private static final int iconSize = 11;
    private Component contentPane;
    private boolean collapsed;
    private boolean fixedSize;
    private JLabel titleLabel;
    private JLabel iconLabel;
    private JPanel headerRow;
    private JPanel contentRow;

    public static JPanel createCollapsiblePaneContainer() {
        return new CollapsiblePaneContainer();
    }

    public CollapsiblePane(String title, Component contentPane, boolean collapsed, boolean fixedSize) {
        this.titleLabel = new JLabel(title);
        this.collapsed = collapsed;
        this.contentPane = contentPane;
        this.fixedSize = fixedSize;
        this.iconLabel = new JLabel();
        this.iconLabel.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CollapsiblePane.this.setCollapsed(!CollapsiblePane.this.isCollapsed());
                CollapsiblePane.this.updateState();
            }
        });
        this.titleLabel = new JLabel(title);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(2));
        JPanel iconDummy = new JPanel();
        iconDummy.setPreferredSize(new Dimension(22, 11));
        this.headerRow = new JPanel(new BorderLayout(2, 0));
        this.headerRow.add((Component)this.iconLabel, "West");
        this.headerRow.add((Component)this.titleLabel, "Center");
        this.contentRow = new JPanel(new BorderLayout(2, 0));
        this.contentRow.add((Component)iconDummy, "West");
        if (contentPane != null) {
            this.contentRow.add(contentPane, "Center");
        }
        this.setLayout(new BorderLayout(2, 2));
        this.add((Component)this.headerRow, "North");
        this.add((Component)this.contentRow, "Center");
        this.updateState();
    }

    public Component getContentPane() {
        return this.contentPane;
    }

    public void setContentPane(Component contentPane) {
        Component oldValue = this.contentPane;
        this.contentPane = contentPane;
        if (oldValue != this.getContentPane()) {
            if (oldValue != null) {
                this.contentRow.remove(oldValue);
            }
            if (this.getContentPane() != null) {
                this.contentRow.add(this.getContentPane(), "Center");
            }
            this.updateState();
            this.firePropertyChange("contentPane", oldValue, this.getContentPane());
        }
    }

    public boolean isFixedSize() {
        return this.fixedSize;
    }

    public void setFixedSize(boolean fixedSize) {
        boolean oldValue = this.isFixedSize();
        this.fixedSize = fixedSize;
        if (oldValue != this.isFixedSize()) {
            this.revalidateParent();
            this.firePropertyChange("fixedSize", oldValue, this.isFixedSize());
        }
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        boolean oldValue = this.isCollapsed();
        this.collapsed = collapsed;
        if (oldValue != this.isCollapsed()) {
            this.updateState();
            this.firePropertyChange("collapsed", oldValue, this.isCollapsed());
        }
    }

    private void updateState() {
        this.updateHeaderRow();
        this.updateContentRow();
    }

    private void updateHeaderRow() {
        this.iconLabel.setIcon(this.collapsed ? collapsedIcon : expandedIcon);
    }

    private void updateContentRow() {
        if (this.isCollapsed()) {
            this.remove(this.contentRow);
        } else {
            this.add((Component)this.contentRow, "Center");
        }
        this.revalidateParent();
    }

    private void revalidateParent() {
        Container parent = this.getParent();
        if (parent != null) {
            parent.invalidate();
            parent.validate();
        }
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setTitle(String title) {
        String oldValue = this.getTitle();
        this.titleLabel.setText(title);
        this.firePropertyChange("title", oldValue, this.getTitle());
        this.repaint();
    }

    private static Icon createHeaderIcon(boolean collapsed) {
        BufferedImage bi = new BufferedImage(11, 11, 1);
        Graphics2D g = bi.createGraphics();
        int n = 10;
        int n2 = n / 2;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, n, n);
        g.setColor(Color.GRAY);
        g.drawRect(0, 0, n, n);
        if (collapsed) {
            g.drawLine(n2, 2, n2, n - 2);
        }
        g.drawLine(2, n2, n - 2, n2);
        g.dispose();
        return new ImageIcon(bi);
    }

    private int getPreferredHeight() {
        return this.getPreferredSize().height;
    }

    private int getPreferredHeaderHeight() {
        return this.headerRow.getPreferredSize().height;
    }

    private static class CollapsiblePaneContainer
    extends JPanel {
        public CollapsiblePaneContainer() {
            super(null);
        }

        @Override
        protected void addImpl(Component component, Object constraints, int index) {
            if (!(component instanceof CollapsiblePane)) {
                throw new IllegalArgumentException("component not a " + CollapsiblePane.class.getName());
            }
            super.addImpl(component, constraints, index);
        }

        @Override
        public void doLayout() {
            Component[] components = this.getComponents();
            ArrayList<Float> weights = new ArrayList<Float>();
            int collapsedHeightSum = 0;
            int expandedHeightSum = 0;
            for (Component component : components) {
                CollapsiblePane collapsiblePane = (CollapsiblePane)component;
                int height = component.getPreferredSize().height;
                if (collapsiblePane.isCollapsed() || collapsiblePane.isFixedSize()) {
                    collapsedHeightSum += height;
                    continue;
                }
                expandedHeightSum += height;
                weights.add(Float.valueOf(height));
            }
            for (int i = 0; i < weights.size(); ++i) {
                weights.set(i, Float.valueOf(((Float)weights.get(i)).floatValue() / (float)expandedHeightSum));
            }
            Insets insets = this.getInsets();
            int availableWidth = this.getWidth() - (insets.left + insets.right);
            int availableHeight = this.getHeight() - (insets.top + insets.bottom);
            int distributableSpace = availableHeight - collapsedHeightSum;
            int x = insets.left;
            int y = insets.top;
            int i = 0;
            for (Component component : components) {
                int headerHeight;
                int currentHeight;
                CollapsiblePane collapsiblePane = (CollapsiblePane)component;
                if (collapsiblePane.isCollapsed() || collapsiblePane.isFixedSize()) {
                    currentHeight = collapsiblePane.getPreferredHeight();
                } else if ((currentHeight = Math.round(((Float)weights.get(i++)).floatValue() * (float)distributableSpace)) < (headerHeight = collapsiblePane.getPreferredHeaderHeight())) {
                    currentHeight = headerHeight;
                }
                component.setBounds(x, y, availableWidth, currentHeight);
                y += currentHeight;
            }
        }
    }
}

