/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.nbmgen;

import com.bc.ceres.nbmgen.CeresModuleProject;
import com.bc.ceres.nbmgen.ManifestWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class NbmGenTool
implements CeresModuleProject.Processor {
    File projectDir;
    String cluster;
    boolean dryRun;

    public NbmGenTool(File projectDir, String cluster, boolean dryRun) {
        this.projectDir = projectDir;
        this.cluster = cluster;
        this.dryRun = dryRun;
    }

    public static void main(String[] args) throws JDOMException, IOException {
        File projectDir = new File(args[0]);
        String cluster = args[1];
        boolean dryRun = args[2].equals("true");
        NbmGenTool processor = new NbmGenTool(projectDir, cluster, dryRun);
        CeresModuleProject.processParentDir(projectDir, processor);
        if (dryRun) {
            NbmGenTool.warnModuleDetail("dry run: file system not modified");
        }
    }

    @Override
    public void process(CeresModuleProject project) throws JDOMException, IOException {
        System.out.println("Project [" + project.projectDir.getName() + "]:");
        File originalPomFile = CeresModuleProject.getFile(project.projectDir, "pom-original.xml");
        File pomFile = CeresModuleProject.getFile(project.projectDir, "pom.xml");
        File manifestBaseFile = CeresModuleProject.getFile(project.projectDir, "src", "main", "nbm", "manifest.mf");
        Element projectElement = project.pomDocument.getRootElement();
        Namespace ns = projectElement.getNamespace();
        Element moduleElement = project.moduleDocument.getRootElement();
        String moduleName = moduleElement.getChildTextTrim("name");
        String moduleDescription = moduleElement.getChildTextNormalize("description");
        String modulePackaging = moduleElement.getChildTextTrim("packaging");
        String moduleNative = moduleElement.getChildTextTrim("native");
        String moduleActivator = moduleElement.getChildTextTrim("activator");
        String moduleChangelog = moduleElement.getChildTextTrim("changelog");
        String moduleFunding = moduleElement.getChildTextTrim("funding");
        String moduleVendor = moduleElement.getChildTextTrim("vendor");
        String moduleContactAddress = moduleElement.getChildTextTrim("contactAddress");
        String moduleCopyright = moduleElement.getChildTextTrim("copyright");
        String moduleLicenseUrl = moduleElement.getChildTextTrim("licenseUrl");
        if (moduleName != null) {
            Element nameElement = NbmGenTool.getOrAddElement(projectElement, "name", ns);
            nameElement.setText(moduleName);
        }
        if (moduleDescription != null) {
            int nameIndex = projectElement.indexOf((Content)projectElement.getChild("name"));
            Element descriptionElement = NbmGenTool.getOrAddElement(projectElement, "description", nameIndex + 1, ns);
            descriptionElement.setText(moduleDescription);
        }
        Element descriptionElement = NbmGenTool.getOrAddElement(projectElement, "packaging", ns);
        descriptionElement.setText("nbm");
        Element urlElement = NbmGenTool.getOrAddElement(projectElement, "url", ns);
        urlElement.setText("https://sentinel.esa.int/web/sentinel/toolboxes");
        Element buildElement = NbmGenTool.getOrAddElement(projectElement, "build", ns);
        Element pluginsElement = NbmGenTool.getOrAddElement(buildElement, "plugins", ns);
        LinkedHashMap<String, String> nbmConfiguration = new LinkedHashMap<String, String>();
        nbmConfiguration.put("moduleType", "normal");
        nbmConfiguration.put("licenseName", "GPL 3");
        nbmConfiguration.put("licenseFile", "../LICENSE.html");
        nbmConfiguration.put("cluster", this.cluster);
        nbmConfiguration.put("defaultCluster", this.cluster);
        nbmConfiguration.put("publicPackages", "");
        nbmConfiguration.put("requiresRestart", "true");
        NbmGenTool.addPluginElement(pluginsElement, "org.apache.netbeans.utilities", "nbm-maven-plugin", nbmConfiguration, ns);
        LinkedHashMap<String, String> jarConfiguration = new LinkedHashMap<String, String>();
        jarConfiguration.put("useDefaultManifestFile", "true");
        NbmGenTool.addPluginElement(pluginsElement, "org.apache.maven.plugins", "maven-jar-plugin", jarConfiguration, ns);
        StringBuilder longDescription = new StringBuilder();
        longDescription.append((String)(moduleDescription != null ? "<p>" + moduleDescription : "")).append(this.descriptionEntry("Funding", moduleFunding)).append(this.descriptionEntry("Vendor", moduleVendor)).append(this.descriptionEntry("Contact address", moduleContactAddress)).append(this.descriptionEntry("Copyright", moduleCopyright)).append(this.descriptionEntry("Vendor", moduleVendor)).append(this.descriptionEntry("License", moduleLicenseUrl)).append(this.descriptionEntry("Changelog", moduleChangelog));
        LinkedHashMap<String, String> manifestContent = new LinkedHashMap<String, String>();
        manifestContent.put("Manifest-Version", "1.0");
        manifestContent.put("AutoUpdate-Show-In-Client", "false");
        manifestContent.put("AutoUpdate-Essential-Module", "true");
        manifestContent.put("OpenIDE-Module-Java-Dependencies", "Java > 1.8");
        manifestContent.put("OpenIDE-Module-Display-Category", "SNAP");
        if (longDescription.length() > 0) {
            manifestContent.put("OpenIDE-Module-Long-Description", longDescription.toString());
        }
        if (moduleActivator != null) {
            NbmGenTool.warnModuleDetail("Activator may be reimplemented for NB: " + moduleActivator + " (--> consider using @OnStart, @OnStop, @OnShowing, or a ModuleInstall)");
            manifestContent.put("OpenIDE-Module-Install", moduleActivator);
        }
        if (modulePackaging != null && !"jar".equals(modulePackaging)) {
            NbmGenTool.warnModuleDetail("Unsupported module packaging: " + modulePackaging + " (--> provide a ModuleInstall that does the job on install/uninstall)");
        }
        if (moduleNative != null && "true".equals(moduleNative)) {
            NbmGenTool.warnModuleDetail("Module contains native code: no auto-conversion possible (--> follow NB instructions see http://bits.netbeans.org/dev/javadoc/org-openide-modules/org/openide/modules/doc-files/api.html#how-layer");
        }
        if (!originalPomFile.exists()) {
            if (!this.dryRun) {
                Files.copy(project.pomFile.toPath(), originalPomFile.toPath(), new CopyOption[0]);
            }
            NbmGenTool.infoModuleDetail("Copied " + project.pomFile + " to " + originalPomFile);
        }
        if (!this.dryRun) {
            NbmGenTool.writeXml(pomFile, project.pomDocument);
        }
        if (pomFile.equals(project.pomFile)) {
            NbmGenTool.infoModuleDetail("Updated " + pomFile);
        } else {
            NbmGenTool.infoModuleDetail("Converted " + project.pomFile + " to " + pomFile);
        }
        if (!this.dryRun) {
            manifestBaseFile.getParentFile().mkdirs();
            NbmGenTool.writeManifest(manifestBaseFile, manifestContent);
        }
        NbmGenTool.infoModuleDetail("Written " + manifestBaseFile);
    }

    private String descriptionEntry(String name, String value) {
        return value != null ? String.format("<p><b>%s:</b> %s", name, value) : "";
    }

    private static void infoModuleDetail(String msg) {
        System.out.println("- " + msg);
    }

    private static void warnModuleDetail(String msg) {
        System.out.println("- WARNING: " + msg);
    }

    private static void writeManifest(File manifestBaseFile, Map<String, String> nbmConfiguration) throws IOException {
        try (ManifestWriter manifestWriter = new ManifestWriter(new FileWriter(manifestBaseFile));){
            for (Map.Entry<String, String> entry : nbmConfiguration.entrySet()) {
                manifestWriter.write(entry.getKey(), entry.getValue());
            }
        }
    }

    private static void addPluginElement(Element pluginsElement, String groupId, String artifactId, Map<String, String> configuration, Namespace ns) {
        Element pluginElement = new Element("plugin", ns);
        Element groupIdElement = new Element("groupId", ns);
        groupIdElement.setText(groupId);
        pluginElement.addContent((Content)groupIdElement);
        Element artifactIdElement = new Element("artifactId", ns);
        artifactIdElement.setText(artifactId);
        pluginElement.addContent((Content)artifactIdElement);
        Element configurationElement = new Element("configuration", ns);
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            Element keyElement = new Element(entry.getKey(), ns);
            keyElement.setText(entry.getValue());
            configurationElement.addContent((Content)keyElement);
        }
        pluginElement.addContent((Content)configurationElement);
        pluginsElement.addContent((Content)pluginElement);
    }

    private static Element getOrAddElement(Element parent, String name, int index, Namespace ns) {
        Element child = parent.getChild(name, ns);
        if (child == null) {
            child = new Element(name, ns);
            if (index >= 0) {
                parent.addContent(index, (Content)child);
            } else {
                parent.addContent((Content)child);
            }
        }
        return child;
    }

    private static Element getOrAddElement(Element parent, String name, Namespace ns) {
        return NbmGenTool.getOrAddElement(parent, name, -1, ns);
    }

    private static void writeXml(File file, Document document) throws IOException {
        XMLOutputter xmlOutput = new XMLOutputter();
        Format format = Format.getPrettyFormat();
        format.setIndent("    ");
        xmlOutput.setFormat(format);
        xmlOutput.output(document, (Writer)new FileWriter(file));
    }
}

