/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.launcher.internal;

import com.bc.ceres.core.runtime.RuntimeConfig;
import com.bc.ceres.core.runtime.RuntimeConfigException;
import com.bc.ceres.launcher.ClasspathFactory;
import com.bc.ceres.launcher.internal.ClasspathFileFilter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public abstract class AbstractClasspathFactory
implements ClasspathFactory {
    protected static final String CERES_LAUNCHER_PREFIX = "ceres-launcher";
    protected static final String CERES_CORE_PREFIX = "ceres-core";
    protected RuntimeConfig config;

    protected AbstractClasspathFactory(RuntimeConfig config) {
        this.config = config;
    }

    public RuntimeConfig getConfig() {
        return this.config;
    }

    @Override
    public URL[] createClasspath() throws RuntimeConfigException {
        this.processClasspathEntries();
        File[] files = this.getClasspathFiles();
        ArrayList<URL> classpathUrls = new ArrayList<URL>(files.length);
        for (File file : files) {
            try {
                URL url = file.toURI().toURL();
                classpathUrls.add(url);
                this.trace(String.format("Library added to classpath: [%s]", file));
            }
            catch (MalformedURLException e) {
                this.trace(String.format("Failed to add library to classpath: malformed library path: [%s]", file));
            }
        }
        this.trace(String.format("%d library(s) added to classpath", classpathUrls.size()));
        return classpathUrls.toArray(new URL[classpathUrls.size()]);
    }

    protected abstract File[] getClasspathFiles() throws RuntimeConfigException;

    protected abstract void processClasspathFile(File var1, LibType var2, int var3);

    private void processClasspathEntries() {
        this.processLibs();
        this.processModules();
    }

    private void processLibs() {
        String[] libDirPaths;
        for (String libDirPath : libDirPaths = this.config.getLibDirPaths()) {
            this.processClasspathEntries(libDirPath, LibType.LIBRARY);
        }
    }

    private void processModules() {
        String moduleDirPath = this.config.getModulesDirPath();
        if (moduleDirPath != null) {
            this.processClasspathEntries(moduleDirPath, LibType.MODULE);
        }
    }

    private void processClasspathEntries(String dirPath, LibType libType) {
        File dir = new File(dirPath);
        if (!dir.isAbsolute()) {
            dir = new File(this.config.getHomeDirPath(), dirPath);
        }
        if (dir.isDirectory()) {
            this.processClasspathEntries(dir.getAbsoluteFile(), libType, 0);
        }
    }

    private void processClasspathEntries(File libDir, LibType libType, int level) {
        File[] files = libDir.listFiles(new ClasspathFileFilter());
        if (files == null) {
            return;
        }
        for (File file : files) {
            this.processClasspathEntry(file, libType, level);
        }
    }

    private void processClasspathEntry(File file, LibType libType, int level) {
        boolean consider;
        if (libType.equals((Object)LibType.MODULE)) {
            if (file.isDirectory()) {
                this.processClasspathEntries(file, LibType.MODULE, level + 1);
            } else if (this.isUninstalledFile(file)) {
                return;
            }
        }
        boolean bl = consider = libType.equals((Object)LibType.LIBRARY) || libType.equals((Object)LibType.MODULE) && (file.isDirectory() && level == 0 || !file.isDirectory());
        if (consider) {
            this.processClasspathFile(file, libType, level);
        }
    }

    private boolean isUninstalledFile(File file) {
        return new File(file.getParent(), file.getName() + ".uninstall").exists();
    }

    private void trace(String msg) {
        if (this.config.isDebug()) {
            this.config.getLogger().info(String.format("ceres-launcher: %s", msg));
        }
    }

    protected static enum LibType {
        LIBRARY,
        MODULE;

    }
}

