/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.runtime.Activator;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.ModuleState;
import com.bc.ceres.core.runtime.internal.DefaultActivator;
import com.bc.ceres.core.runtime.internal.DefaultModuleContext;
import com.bc.ceres.core.runtime.internal.ModuleImpl;

public class ModuleStarter {
    private ModuleImpl module;

    public ModuleStarter(ModuleImpl module) {
        this.module = module;
    }

    public Module getModule() {
        return this.module;
    }

    public void run() throws CoreException {
        ModuleStarter.runImpl(this.module);
    }

    private static void runImpl(ModuleImpl module) throws CoreException {
        if (module.getState() != ModuleState.STARTING && module.getState() != ModuleState.ACTIVE) {
            Activator activator;
            if (module.getState() != ModuleState.RESOLVED) {
                throw new CoreException(String.format("Failed to start module [%s], RESOLVED state required", module.getSymbolicName()));
            }
            module.setState(ModuleState.STARTING);
            DefaultModuleContext context = new DefaultModuleContext(module);
            module.setContext(context);
            try {
                activator = ModuleStarter.createActivator(module);
            }
            catch (Throwable t) {
                module.setState(ModuleState.RESOLVED);
                throw new CoreException(t);
            }
            module.setActivator(activator);
            try {
                activator.start(context);
            }
            catch (Throwable t) {
                module.setState(ModuleState.RESOLVED);
                throw new CoreException(t);
            }
            module.setState(ModuleState.ACTIVE);
        }
    }

    public static Activator createActivator(ModuleImpl module) throws Exception {
        Activator activator;
        if (module.getActivatorClassName() != null) {
            Class<?> aClass = module.loadClass(module.getActivatorClassName());
            activator = (Activator)aClass.newInstance();
        } else {
            activator = new DefaultActivator();
        }
        return activator;
    }
}

