/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.runtime.ConfigurationElement;
import com.bc.ceres.core.runtime.Extension;
import com.bc.ceres.core.runtime.ExtensionPoint;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.internal.ConfigurationElementImpl;
import com.bc.ceres.core.runtime.internal.ConfigurationSchemaElementImpl;
import com.bc.ceres.core.runtime.internal.ModuleImpl;
import com.bc.ceres.core.runtime.internal.ModuleRegistry;

public class ExtensionImpl
implements Extension {
    public static final ExtensionImpl[] EMPTY_ARRAY = new ExtensionImpl[0];
    private final String point;
    private final ConfigurationElementImpl configurationElement;
    private final String id;
    private transient ModuleImpl declaringModule;
    private ExtensionPoint extensionPoint;

    public ExtensionImpl(String point, ConfigurationElementImpl configurationElement, String id) {
        Assert.notNull(point, "point");
        Assert.notNull(configurationElement, "configurationElement");
        this.point = point;
        this.configurationElement = configurationElement;
        this.configurationElement.setDeclaringExtension(this);
        this.id = id;
    }

    @Override
    public String getPoint() {
        return this.point;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ConfigurationElement getConfigurationElement() {
        this.lazilyResolveExtensionPoint();
        return this.configurationElement;
    }

    @Override
    public Module getDeclaringModule() {
        return this.declaringModule;
    }

    void setDeclaringModule(ModuleImpl declaringModule) {
        this.declaringModule = declaringModule;
    }

    @Override
    public ExtensionPoint getExtensionPoint() {
        this.lazilyResolveExtensionPoint();
        return this.extensionPoint;
    }

    private void lazilyResolveExtensionPoint() {
        ModuleRegistry registry;
        if (this.extensionPoint == null && (registry = this.declaringModule.getRegistry()) != null) {
            this.extensionPoint = registry.getExtensionPoint(this.point, this.declaringModule);
            if (this.extensionPoint != null) {
                this.configurationElement.setSchemaElement((ConfigurationSchemaElementImpl)this.extensionPoint.getConfigurationSchemaElement());
            }
        }
    }
}

