/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.runtime.RuntimeConfig;
import com.bc.ceres.core.runtime.RuntimeConfigException;
import com.bc.ceres.util.TemplateReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.security.CodeSource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class DefaultRuntimeConfig
implements RuntimeConfig {
    public static final String CONFIG_KEY_CERES_CONTEXT = "ceres.context";
    public static final String CONFIG_KEY_DEBUG = "debug";
    public static final String CONFIG_KEY_MAIN_CLASS = "mainClass";
    public static final String CONFIG_KEY_CLASSPATH = "classpath";
    public static final String CONFIG_KEY_HOME = "home";
    public static final String CONFIG_KEY_CONFIG_FILE_NAME = "config";
    public static final String CONFIG_KEY_MODULES = "modules";
    public static final String CONFIG_KEY_LIB_DIRS = "libDirs";
    public static final String CONFIG_KEY_APP = "app";
    public static final String CONFIG_KEY_CONSOLE_LOG = "consoleLog";
    public static final String CONFIG_KEY_LOG_LEVEL = "logLevel";
    public static final String DEFAULT_CERES_CONTEXT = "ceres";
    public static final String DEFAULT_MAIN_CLASS_NAME = "com.bc.ceres.core.runtime.RuntimeLauncher";
    public static final String DEFAULT_MODULES_DIR_NAME = "modules";
    public static final String DEFAULT_CONFIG_DIR_NAME = "config";
    public static final String DEFAULT_LIB_DIR_NAME = "lib";
    public static final SimpleDateFormat LOG_TIME_STAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final Properties properties = System.getProperties();
    private String contextId;
    private String debugKey;
    private boolean debug;
    private String homeDirKey;
    private String homeDirPath;
    private String mainClassKey;
    private String mainClassName;
    private String classpathKey;
    private String mainClassPath;
    private String applicationIdKey;
    private String applicationId;
    private String configFileKey;
    private String configFilePath;
    private String defaultRelConfigFilePath;
    private String defaultHomeConfigFilePath;
    private String modulesDirKey;
    private String modulesDirPath;
    private String defaultHomeModulesDirPath;
    private String libDirsKey;
    private String[] libDirPaths;
    private String defaultHomeLibDirPath;
    private Logger logger;
    private boolean homeDirAssumed;
    private String consoleLogKey;
    private String logLevelKey;
    private Level logLevel;
    private boolean consoleLog;

    public DefaultRuntimeConfig() throws RuntimeConfigException {
        this.initAll();
    }

    @Override
    public String getContextId() {
        return this.contextId;
    }

    @Override
    public String getContextProperty(String key) {
        return this.getContextProperty(key, null);
    }

    @Override
    public String getContextProperty(String key, String defaultValue) {
        return this.getProperty(this.contextId + "." + key, defaultValue);
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public String getMainClassName() {
        return this.mainClassName;
    }

    @Override
    public String getMainClassPath() {
        return this.mainClassPath;
    }

    @Override
    public String getHomeDirPath() {
        return this.homeDirPath;
    }

    @Override
    public String getConfigFilePath() {
        return this.configFilePath;
    }

    @Override
    public String[] getLibDirPaths() {
        return this.libDirPaths;
    }

    @Override
    public String getModulesDirPath() {
        return this.modulesDirPath;
    }

    @Override
    public boolean isUsingModuleRuntime() {
        return DEFAULT_MAIN_CLASS_NAME.equals(this.mainClassName);
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    private void initAll() throws RuntimeConfigException {
        this.initContext();
        this.initDebug();
        this.initHomeDirAndConfiguration();
        this.initDebug();
        this.initMainClassName();
        this.initClasspathPaths();
        this.initModulesDir();
        this.initLibDirs();
        if (this.isUsingModuleRuntime()) {
            this.initAppId();
        }
        this.initLogLevel();
        this.initConsoleLog();
        if (System.getProperty("platform") != null && System.getProperty("platform").equals("CEMS")) {
            this.initCemsLogger();
        } else {
            this.initDefaultLogger();
        }
        this.setAutoDetectProperties();
    }

    private void initContext() {
        this.contextId = System.getProperty(CONFIG_KEY_CERES_CONTEXT, DEFAULT_CERES_CONTEXT);
        this.homeDirKey = String.format("%s.%s", this.contextId, CONFIG_KEY_HOME);
        this.debugKey = String.format("%s.%s", this.contextId, CONFIG_KEY_DEBUG);
        this.configFileKey = String.format("%s.%s", this.contextId, "config");
        this.modulesDirKey = String.format("%s.%s", this.contextId, "modules");
        this.libDirsKey = String.format("%s.%s", this.contextId, CONFIG_KEY_LIB_DIRS);
        this.mainClassKey = String.format("%s.%s", this.contextId, CONFIG_KEY_MAIN_CLASS);
        this.classpathKey = String.format("%s.%s", this.contextId, CONFIG_KEY_CLASSPATH);
        this.applicationIdKey = String.format("%s.%s", this.contextId, CONFIG_KEY_APP);
        this.logLevelKey = String.format("%s.%s", this.contextId, CONFIG_KEY_LOG_LEVEL);
        this.consoleLogKey = String.format("%s.%s", this.contextId, CONFIG_KEY_CONSOLE_LOG);
        char sep = File.separatorChar;
        this.defaultRelConfigFilePath = String.format("%s/%s", "config", this.configFileKey).replace('/', sep);
        this.defaultHomeConfigFilePath = String.format("${%s}/%s", this.homeDirKey, this.defaultRelConfigFilePath).replace('/', sep);
        this.defaultHomeModulesDirPath = String.format("${%s}/%s", this.homeDirKey, "modules").replace('/', sep);
        this.defaultHomeLibDirPath = String.format("${%s}/%s", this.homeDirKey, DEFAULT_LIB_DIR_NAME).replace('/', sep);
    }

    private void initDebug() {
        this.debug = Boolean.valueOf(System.getProperty(this.debugKey, Boolean.toString(this.debug)));
    }

    private void initHomeDirAndConfiguration() throws RuntimeConfigException {
        this.maybeInitHomeDirAndConfigFile();
        if (this.configFilePath != null) {
            this.loadConfiguration();
        } else {
            this.trace("A configuration file is not used.");
        }
        this.initHomeDirIfNotAlreadyDone();
    }

    private void maybeInitHomeDirAndConfigFile() throws RuntimeConfigException {
        this.maybeInitHomeDir();
        this.maybeInitConfigFile();
        if (this.homeDirPath == null && this.configFilePath == null) {
            this.assumeHomeDir();
        }
        if (this.configFilePath == null) {
            this.maybeInitDefaultConfigFile();
        }
    }

    private void maybeInitHomeDir() throws RuntimeConfigException {
        String homeDirPath = this.getProperty(this.homeDirKey);
        if (!DefaultRuntimeConfig.isNullOrEmptyString(homeDirPath)) {
            File homeDir = new File(homeDirPath);
            if (!homeDir.isDirectory()) {
                throw DefaultRuntimeConfig.createInvalidPropertyValueException(this.homeDirKey, homeDirPath);
            }
            try {
                this.homeDirPath = homeDir.getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeConfigException(e.getMessage(), e);
            }
        }
    }

    private void maybeInitConfigFile() throws RuntimeConfigException {
        String configFilePath = this.getProperty(this.configFileKey);
        if (!DefaultRuntimeConfig.isNullOrEmptyString(configFilePath)) {
            File configFile = new File(configFilePath);
            if (!configFile.isFile()) {
                throw DefaultRuntimeConfig.createInvalidPropertyValueException(this.configFileKey, configFile.getPath());
            }
            try {
                this.configFilePath = configFile.getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeConfigException(e.getMessage(), e);
            }
        }
    }

    private void maybeInitDefaultConfigFile() {
        File configFile = new File(this.substitute(this.defaultHomeConfigFilePath));
        if (configFile.isFile()) {
            this.configFilePath = configFile.getPath();
        }
    }

    private void assumeHomeDir() {
        List<File> possibleHomeDirList = DefaultRuntimeConfig.createPossibleHomeDirList();
        List<String> homeContentPathList = this.createHomeContentPathList();
        this.trace("Auto-detecting home directory...");
        File mostLikelyHomeDir = this.findMostLikelyHomeDir(possibleHomeDirList, homeContentPathList);
        this.homeDirPath = mostLikelyHomeDir != null ? mostLikelyHomeDir.getPath() : new File(".").getAbsolutePath();
        this.homeDirAssumed = true;
        this.setProperty(this.homeDirKey, this.homeDirPath);
    }

    private File findMostLikelyHomeDir(List<File> possibleHomeDirList, List<String> homeContentPathList) {
        int numFoundMax = 0;
        File mostLikelyHomeDir = null;
        for (File possibleHomeDir : possibleHomeDirList) {
            this.trace(String.format("Is [%s] my home directory?", possibleHomeDir));
            int numFound = 0;
            for (String homeContentPath : homeContentPathList) {
                File homeContentFile = new File(possibleHomeDir, homeContentPath);
                if (homeContentFile.exists()) {
                    this.trace(String.format("  [%s] contained? Yes.", homeContentPath));
                    ++numFound;
                    continue;
                }
                this.trace(String.format("  [%s] contained? No.", homeContentPath));
            }
            if (numFound == 0) {
                this.trace("No.");
            } else {
                this.trace(String.format("Maybe. %d related file(s) found.", numFound));
            }
            if (numFound <= numFoundMax) continue;
            try {
                mostLikelyHomeDir = possibleHomeDir.getCanonicalFile();
                numFoundMax = numFound;
            }
            catch (IOException iOException) {}
        }
        return mostLikelyHomeDir;
    }

    private static List<File> createPossibleHomeDirList() {
        String libPath;
        File libParentDir;
        URL libUrl;
        ArrayList<File> homeDirCheckList = new ArrayList<File>(4);
        CodeSource lib = DefaultRuntimeConfig.class.getProtectionDomain().getCodeSource();
        if (lib != null && (libUrl = lib.getLocation()).getProtocol().equals("file") && (libParentDir = new File(libPath = libUrl.getPath()).getParentFile()) != null) {
            if (libParentDir.getParentFile() != null) {
                homeDirCheckList.add(libParentDir.getParentFile());
            }
            homeDirCheckList.add(libParentDir);
        }
        homeDirCheckList.add(new File(".").getAbsoluteFile());
        homeDirCheckList.add(new File("..").getAbsoluteFile());
        return homeDirCheckList;
    }

    private List<String> createHomeContentPathList() {
        ArrayList<String> homeContentPathList = new ArrayList<String>(8);
        homeContentPathList.add(this.defaultRelConfigFilePath);
        homeContentPathList.add("bin");
        homeContentPathList.add(DEFAULT_LIB_DIR_NAME);
        homeContentPathList.add("modules");
        return homeContentPathList;
    }

    private void loadConfiguration() throws RuntimeConfigException {
        this.trace(String.format("Loading configuration from [%s]", this.configFilePath));
        try (FileInputStream stream = new FileInputStream(this.configFilePath);){
            Properties fileProperties = new Properties();
            fileProperties.load(stream);
            Enumeration<?> enumeration = fileProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                Object value;
                Object key = enumeration.nextElement();
                if (!(key instanceof String) || !((value = fileProperties.get(key)) instanceof String)) continue;
                String keyString = (String)key;
                String propertyValue = fileProperties.getProperty(keyString);
                if (!this.isPropertySet(keyString)) {
                    this.setProperty(keyString, propertyValue);
                    this.trace(String.format("Configuration property [%s] added", keyString));
                    continue;
                }
                this.trace(String.format("Configuration property [%s] ignored", keyString));
            }
        }
        catch (IOException e) {
            throw new RuntimeConfigException(String.format("Failed to load configuration [%s]", this.configFilePath), e);
        }
    }

    private void initHomeDirIfNotAlreadyDone() throws RuntimeConfigException {
        if (this.homeDirPath == null || this.homeDirAssumed) {
            this.maybeInitHomeDir();
        }
        if (this.homeDirPath == null) {
            this.homeDirPath = new File(".").getAbsolutePath();
            this.homeDirAssumed = true;
        }
        try {
            this.homeDirPath = new File(this.homeDirPath).getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeConfigException("Home directory is invalid.", e);
        }
        if (this.homeDirAssumed) {
            this.trace(String.format("Home directory not set. Using assumed default.", new Object[0]));
        }
        this.trace(String.format("Home directory is [%s]", this.homeDirPath));
    }

    private void initMainClassName() throws RuntimeConfigException {
        this.mainClassName = this.getProperty(this.mainClassKey, DEFAULT_MAIN_CLASS_NAME);
        if (DefaultRuntimeConfig.isNullOrEmptyString(this.mainClassName)) {
            throw DefaultRuntimeConfig.createMissingPropertyKeyException(this.mainClassKey);
        }
    }

    private void initClasspathPaths() throws RuntimeConfigException {
        this.mainClassPath = this.getProperty(this.classpathKey, null);
    }

    private void initModulesDir() throws RuntimeConfigException {
        this.modulesDirPath = null;
        String modulesDirPath = this.getProperty(this.modulesDirKey);
        try {
            if (modulesDirPath != null) {
                File modulesDir = new File(modulesDirPath);
                if (!modulesDir.isDirectory()) {
                    throw DefaultRuntimeConfig.createInvalidPropertyValueException(this.modulesDirKey, modulesDirPath);
                }
                this.modulesDirPath = modulesDir.getCanonicalPath();
            } else {
                File modulesDir = new File(this.substitute(this.defaultHomeModulesDirPath));
                if (modulesDir.isDirectory()) {
                    this.modulesDirPath = modulesDir.getCanonicalPath();
                }
            }
        }
        catch (IOException e) {
            String msg = String.format("Could not convert modules dir path [%s] into its canonical form.", modulesDirPath);
            throw new RuntimeConfigException(msg, e);
        }
    }

    private void initLibDirs() throws RuntimeConfigException {
        this.libDirPaths = new String[0];
        String libDirPathsString = this.getProperty(this.libDirsKey);
        if (libDirPathsString != null) {
            String[] libDirPaths;
            for (String libDirPath : libDirPaths = DefaultRuntimeConfig.splitLibDirPaths(libDirPathsString)) {
                File libDir = new File(libDirPath);
                if (libDir.isDirectory()) continue;
                throw DefaultRuntimeConfig.createInvalidPropertyValueException(this.libDirsKey, libDirPathsString);
            }
            this.libDirPaths = libDirPaths;
        } else {
            libDirPathsString = this.substitute(this.defaultHomeLibDirPath);
            File libDir = new File(libDirPathsString);
            if (libDir.isDirectory()) {
                this.libDirPaths = new String[]{libDirPathsString};
            }
        }
    }

    private void initAppId() throws RuntimeConfigException {
        this.applicationId = this.getProperty(this.applicationIdKey);
        if (this.applicationId != null && this.applicationId.length() == 0) {
            throw DefaultRuntimeConfig.createMissingPropertyKeyException(this.applicationIdKey);
        }
    }

    private void initLogLevel() {
        String logLevelStr = this.getProperty(this.logLevelKey, Level.OFF.getName());
        Level[] validLevels = new Level[]{Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL, Level.OFF};
        this.logLevel = Level.OFF;
        for (Level level : validLevels) {
            if (!level.getName().equalsIgnoreCase(logLevelStr)) continue;
            this.logLevel = level;
            break;
        }
    }

    private void initConsoleLog() {
        String consoleLogStr = this.getProperty(this.consoleLogKey, "false");
        this.consoleLog = Boolean.parseBoolean(consoleLogStr);
    }

    private void initDefaultLogger() {
        Handler[] handlers;
        ConsoleHandler consoleHandler = null;
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            consoleHandler = (ConsoleHandler)handler;
            rootLogger.removeHandler(handler);
        }
        this.logger = Logger.getLogger(this.contextId);
        this.logger.setLevel(this.logLevel);
        if (!this.logLevel.equals(Level.OFF)) {
            for (Handler handler : this.logger.getHandlers()) {
                if (!(handler.getFormatter() instanceof LogFormatter)) continue;
                return;
            }
            LogFormatter formatter = new LogFormatter();
            if (this.consoleLog) {
                if (consoleHandler == null) {
                    consoleHandler = new ConsoleHandler();
                }
                consoleHandler.setFormatter(formatter);
                consoleHandler.setLevel(this.logLevel);
                this.logger.addHandler(consoleHandler);
            }
            String userHomePath = this.getProperty("user.home", ".");
            File logDir = new File(userHomePath, "." + this.contextId + "/log");
            logDir.mkdirs();
            String logFilePattern = new File(logDir, this.contextId + "-%g.log").getPath();
            try {
                FileHandler fileHandler = new FileHandler(logFilePattern);
                fileHandler.setFormatter(formatter);
                fileHandler.setLevel(this.logLevel);
                this.logger.addHandler(fileHandler);
            }
            catch (IOException e) {
                System.err.println("Error: Failed to create log file: " + logFilePattern);
            }
        }
    }

    private void initCemsLogger() {
        if (this.logger == null) {
            Handler[] handlers;
            final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Formatter formatter = new Formatter(){

                @Override
                public String format(LogRecord record) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(dateFormat.format(new Date(record.getMillis())));
                    sb.append(" - ");
                    sb.append(record.getLevel().getName());
                    sb.append(": ");
                    sb.append(record.getMessage());
                    sb.append("\n");
                    Throwable thrown = record.getThrown();
                    if (thrown != null) {
                        sb.append(thrown.toString());
                        sb.append("\n");
                    }
                    return sb.toString();
                }
            };
            ConsoleHandler handler = new ConsoleHandler();
            handler.setFormatter(formatter);
            handler.setLevel(Level.ALL);
            this.logger = Logger.getLogger("ga.cems");
            for (Handler h : handlers = this.logger.getHandlers()) {
                this.logger.removeHandler(h);
            }
            this.logger.setUseParentHandlers(false);
            this.logger.addHandler(handler);
        }
        this.logger.setLevel(this.logLevel);
    }

    private void setAutoDetectProperties() {
        this.setPropertyIfNotSet(this.homeDirKey, this.getHomeDirPath());
        this.setPropertyIfNotSet(this.configFileKey, this.getConfigFilePath());
        this.setPropertyIfNotSet(this.modulesDirKey, this.getModulesDirPath());
        String libDirPaths = DefaultRuntimeConfig.assembleLibDirPaths(this.getLibDirPaths());
        this.setPropertyIfNotSet(this.libDirsKey, libDirPaths.length() > 0 ? libDirPaths : null);
    }

    private void setPropertyIfNotSet(String key, String value) {
        if (!this.isPropertySet(key)) {
            this.setProperty(key, value);
        }
    }

    private static boolean isNullOrEmptyString(String value) {
        return value == null || value.length() == 0;
    }

    private static String[] splitLibDirPaths(String libDirPathsString) {
        ArrayList<String> libDirPathList = new ArrayList<String>(8);
        StringTokenizer stringTokenizer = new StringTokenizer(libDirPathsString, File.pathSeparator);
        while (stringTokenizer.hasMoreElements()) {
            String libDirPath = (String)stringTokenizer.nextElement();
            libDirPathList.add(libDirPath);
        }
        return libDirPathList.toArray(new String[libDirPathList.size()]);
    }

    private static String assembleLibDirPaths(String[] libDirPaths) {
        StringBuilder sb = new StringBuilder(64);
        for (String libDirPath : libDirPaths) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(libDirPath);
        }
        return sb.toString();
    }

    private static RuntimeConfigException createMissingPropertyKeyException(String key) {
        return new RuntimeConfigException(String.format("Property '%s' has not been set.", key));
    }

    private static RuntimeConfigException createInvalidPropertyValueException(String key, String value) {
        return new RuntimeConfigException(String.format("Value of property '%s' is invalid: %s", key, value));
    }

    private void trace(String msg) {
        if (this.debug) {
            System.out.println(String.format("[DEBUG] ceres-config: %s", msg));
        }
    }

    private boolean isPropertySet(String key) {
        return this.properties.containsKey(key);
    }

    private String getProperty(String key) {
        return this.getProperty(key, null);
    }

    private String getProperty(String key, String defaultValue) {
        String property = this.properties.getProperty(key, defaultValue);
        if (property != null) {
            return this.substitute(property);
        }
        return property;
    }

    private void setProperty(String key, String value) {
        if (value != null) {
            this.properties.setProperty(key, value);
        } else {
            this.properties.remove(key);
        }
    }

    private String substitute(String value) {
        if (value.indexOf(36) == -1) {
            return value;
        }
        StringReader r = new StringReader(value);
        try {
            return new TemplateReader((Reader)r, this.properties).readAll();
        }
        catch (IOException e) {
            return value;
        }
    }

    private static class LogFormatter
    extends Formatter {
        private LogFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.append('[');
            pw.append(record.getLevel().toString());
            pw.append(']');
            pw.append(' ');
            pw.append(LOG_TIME_STAMP_FORMAT.format(new Date(record.getMillis())));
            pw.append(' ');
            pw.append('-');
            pw.append(' ');
            pw.append(record.getMessage());
            Throwable thrown = record.getThrown();
            if (thrown != null) {
                pw.println();
                thrown.printStackTrace(pw);
            }
            pw.println();
            return sw.toString();
        }
    }
}

