/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.runtime.ConfigurationElementBase;
import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.util.ArrayList;

public abstract class ConfigurationElementBaseImpl<T extends ConfigurationElementBase>
implements ConfigurationElementBase<T> {
    private final T parent;
    private final XppDom dom;
    private T[] children;

    protected ConfigurationElementBaseImpl(T parent, XppDom dom) {
        this.dom = dom;
        this.parent = parent;
    }

    XppDom getDom() {
        return this.dom;
    }

    @Override
    public T getParent() {
        return this.parent;
    }

    @Override
    public T getChild(String elementName) {
        ConfigurationElementBase[] children;
        for (ConfigurationElementBase child : children = this.getChildren()) {
            if (!child.getName().equals(elementName)) continue;
            return (T)child;
        }
        return null;
    }

    @Override
    public T[] getChildren() {
        if (this.children == null) {
            this.children = this.createChildren(this.getDom().getChildren());
        }
        return this.children;
    }

    @Override
    public T[] getChildren(String elementName) {
        ConfigurationElementBase[] children = this.getChildren();
        ArrayList<ConfigurationElementBase> list = new ArrayList<ConfigurationElementBase>(children.length);
        for (ConfigurationElementBase child : children) {
            if (!child.getName().equals(elementName)) continue;
            list.add(child);
        }
        int n = list.size();
        return list.toArray(this.createEmptyArray(n));
    }

    @Override
    public String getName() {
        return this.getDom().getName();
    }

    @Override
    public String getValue() {
        return this.getDom().getValue();
    }

    @Override
    public String getAttribute(String attributeName) {
        return this.getDom().getAttribute(attributeName);
    }

    @Override
    public String[] getAttributeNames() {
        return this.getDom().getAttributeNames();
    }

    protected abstract T[] createChildren(XppDom[] var1);

    protected abstract T[] createEmptyArray(int var1);
}

