/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core;

import com.bc.ceres.core.Assert;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class VirtualDir {
    private static final int TEMP_DIR_ATTEMPTS = 10000;

    public abstract String getBasePath();

    public abstract File getBaseFile();

    public Reader getReader(String path) throws IOException {
        return new InputStreamReader(this.getInputStream(path));
    }

    public abstract InputStream getInputStream(String var1) throws IOException;

    public abstract File getFile(String var1) throws IOException;

    public abstract String[] list(String var1) throws IOException;

    public abstract boolean exists(String var1);

    public abstract String[] listAllFiles() throws IOException;

    public abstract void close();

    public static VirtualDir create(File file) {
        if (file.isDirectory()) {
            return new Dir(file);
        }
        try {
            return new Zip(new ZipFile(file));
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public abstract boolean isCompressed();

    public abstract boolean isArchive();

    public File getTempDir() throws IOException {
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public static void deleteFileTree(File treeRoot) {
        Assert.notNull(treeRoot);
        File[] files = treeRoot.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    VirtualDir.deleteFileTree(file);
                    continue;
                }
                file.delete();
            }
        }
        treeRoot.delete();
    }

    public static File createUniqueTempDir() throws IOException {
        File baseDir = VirtualDir.getBaseTempDir();
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + "9999)");
    }

    private static File getBaseTempDir() throws IOException {
        File tempDir;
        String contextId = "snap";
        String tempDirName = System.getProperty("java.io.tmpdir");
        if (tempDirName != null) {
            tempDir = new File(tempDirName);
            if (tempDir.exists()) {
                String userName = System.getProperty("user.name");
                tempDir = new File(tempDir, contextId + "-" + userName);
                tempDir.mkdir();
            }
        } else {
            tempDir = new File(System.getProperty("user.home", "."), "." + contextId + "/temp");
            tempDir.mkdirs();
        }
        if (!tempDir.exists()) {
            throw new IOException("Temporary directory not available: " + tempDir);
        }
        return tempDir;
    }

    private static class NIO
    extends VirtualDir {
        private final Path virtualDirPath;
        private final String basePath;
        private final boolean isCompressed;
        private final boolean isArchive;
        private final boolean localCopyRequired;
        private Path tempZipFilePathStore;

        private NIO(Path virtualDirPath, String basePath, boolean isCompressed, boolean isArchive, boolean localCopyRequired) {
            this.virtualDirPath = virtualDirPath;
            this.basePath = basePath;
            this.isCompressed = isCompressed;
            this.isArchive = isArchive;
            this.localCopyRequired = localCopyRequired;
        }

        @Override
        public String getBasePath() {
            return this.basePath;
        }

        @Override
        public File getBaseFile() {
            return this.virtualDirPath.toFile();
        }

        @Override
        public InputStream getInputStream(String path) throws IOException {
            Path resolve = this.virtualDirPath.resolve(path);
            if (Files.exists(resolve, new LinkOption[0])) {
                InputStream inputStream = Files.newInputStream(resolve, new OpenOption[0]);
                if (path.endsWith(".gz")) {
                    return new GZIPInputStream(new BufferedInputStream(inputStream));
                }
                return new BufferedInputStream(inputStream);
            }
            throw new FileNotFoundException(resolve.toString());
        }

        @Override
        public synchronized File getFile(String path) throws IOException {
            Path resolve = this.virtualDirPath.resolve(path);
            if (!Files.exists(resolve, new LinkOption[0])) {
                throw new FileNotFoundException(resolve.toString());
            }
            if (this.localCopyRequired) {
                Path tempFilePath;
                if (this.tempZipFilePathStore == null) {
                    this.tempZipFilePathStore = VirtualDir.createUniqueTempDir().toPath();
                }
                if (Files.notExists(tempFilePath = this.tempZipFilePathStore.resolve(path), new LinkOption[0])) {
                    if (Files.notExists(tempFilePath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(tempFilePath.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(resolve, tempFilePath, new CopyOption[0]);
                }
                return tempFilePath.toFile();
            }
            return resolve.toFile();
        }

        @Override
        public String[] list(String path) throws IOException {
            Path startingPath = this.virtualDirPath.resolve(path);
            if (!Files.exists(startingPath, new LinkOption[0])) {
                throw new FileNotFoundException(startingPath.toString());
            }
            ArrayList<String> fileNames = new ArrayList<String>();
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(startingPath);){
                for (Path child : directoryStream) {
                    String filename = child.getFileName().toString();
                    if (filename.endsWith("/") && filename.length() > 0) {
                        filename = filename.substring(0, filename.length() - 1);
                    }
                    fileNames.add(filename);
                }
            }
            return fileNames.toArray(new String[fileNames.size()]);
        }

        @Override
        public String[] listAllFiles() throws IOException {
            try (Stream<Path> pathStream = Files.walk(this.virtualDirPath, new FileVisitOption[0]);){
                Stream<Path> filteredstream = pathStream.filter(new Predicate<Path>(){

                    @Override
                    public boolean test(Path path) {
                        return Files.isRegularFile(path, new LinkOption[0]);
                    }
                });
                final int baseLength = this.virtualDirPath.toUri().toString().length();
                Stream<String> fileStream = filteredstream.map(new Function<Path, String>(){

                    @Override
                    public String apply(Path path) {
                        return path.toUri().toString().substring(baseLength);
                    }
                });
                String[] stringArray = (String[])fileStream.toArray((IntFunction<A[]>)new IntFunction<String[]>(){

                    @Override
                    public String[] apply(int value) {
                        return new String[value];
                    }
                });
                return stringArray;
            }
        }

        @Override
        public boolean exists(String path) {
            return Files.exists(this.virtualDirPath.resolve(path), new LinkOption[0]);
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isCompressed() {
            return this.isCompressed;
        }

        @Override
        public boolean isArchive() {
            return this.isArchive;
        }

        @Override
        public File getTempDir() throws IOException {
            return this.tempZipFilePathStore.toFile();
        }

        @Override
        protected void finalize() throws Throwable {
            super.finalize();
            this.cleanup();
        }

        private void cleanup() {
            if (this.tempZipFilePathStore != null) {
                NIO.deleteFileTree(this.tempZipFilePathStore.toFile());
            }
        }
    }

    private static class Zip
    extends VirtualDir {
        private static final int BUFFER_SIZE = 0x400000;
        private ZipFile zipFile;
        private File tempZipFileDir;

        private Zip(ZipFile zipFile) {
            this.zipFile = zipFile;
        }

        @Override
        public String getBasePath() {
            return this.zipFile.getName();
        }

        @Override
        public File getBaseFile() {
            return new File(this.zipFile.getName());
        }

        @Override
        public InputStream getInputStream(String path) throws IOException {
            return this.getInputStream(this.getEntry(path));
        }

        @Override
        public File getFile(String path) throws IOException {
            File tempFile;
            ZipEntry zipEntry = this.getEntry(path);
            if (this.tempZipFileDir == null) {
                this.tempZipFileDir = VirtualDir.createUniqueTempDir();
            }
            if ((tempFile = new File(this.tempZipFileDir, zipEntry.getName())).exists()) {
                return tempFile;
            }
            if (zipEntry.isDirectory()) {
                tempFile.mkdirs();
            } else {
                this.unzip(zipEntry, tempFile);
            }
            return tempFile;
        }

        @Override
        public String[] list(String path) throws IOException {
            if (".".equals(path) || ((String)path).isEmpty()) {
                path = "";
            } else if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            boolean dirSeen = false;
            TreeSet<String> nameSet = new TreeSet<String>();
            Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String name = zipEntry.getName();
                if (!name.startsWith((String)path)) continue;
                int i1 = ((String)path).length();
                int i2 = name.indexOf(47, i1);
                String entryName = i2 == -1 ? name.substring(i1) : name.substring(i1, i2);
                if (!entryName.isEmpty() && !nameSet.contains(entryName)) {
                    nameSet.add(entryName);
                }
                dirSeen = true;
            }
            if (!dirSeen) {
                throw new FileNotFoundException(this.getBasePath() + "!" + (String)path);
            }
            return nameSet.toArray(new String[nameSet.size()]);
        }

        @Override
        public boolean exists(String path) {
            try {
                ZipEntry zipEntry = this.getEntry(path);
                return zipEntry != null;
            }
            catch (FileNotFoundException e) {
                return false;
            }
        }

        @Override
        public String[] listAllFiles() {
            ArrayList<String> filenameList = new ArrayList<String>();
            Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                filenameList.add(zipEntry.getName());
            }
            return filenameList.toArray(new String[0]);
        }

        @Override
        public void close() {
            this.cleanup();
        }

        @Override
        protected void finalize() throws Throwable {
            super.finalize();
            this.cleanup();
        }

        @Override
        public boolean isCompressed() {
            return true;
        }

        @Override
        public boolean isArchive() {
            return true;
        }

        @Override
        public File getTempDir() throws IOException {
            return this.tempZipFileDir;
        }

        private void cleanup() {
            try {
                this.zipFile.close();
                this.zipFile = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.tempZipFileDir != null) {
                Zip.deleteFileTree(this.tempZipFileDir);
            }
        }

        private InputStream getInputStream(ZipEntry zipEntry) throws IOException {
            InputStream inputStream = this.zipFile.getInputStream(zipEntry);
            if (zipEntry.getName().endsWith(".gz")) {
                return new GZIPInputStream(inputStream);
            }
            return inputStream;
        }

        private ZipEntry getEntry(String path) throws FileNotFoundException {
            ZipEntry zipEntry = this.zipFile.getEntry(path);
            if (zipEntry == null) {
                throw new FileNotFoundException(this.zipFile.getName() + "!" + path);
            }
            return zipEntry;
        }

        private void unzip(ZipEntry zipEntry, File tempFile) throws IOException {
            block14: {
                try (InputStream is = this.zipFile.getInputStream(zipEntry);){
                    if (is == null) break block14;
                    tempFile.getParentFile().mkdirs();
                    try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tempFile), 0x400000);){
                        int n;
                        byte[] bytes = new byte[1024];
                        while ((n = is.read(bytes)) > 0) {
                            os.write(bytes, 0, n);
                        }
                    }
                    catch (IOException ioe) {
                        throw new IOException("Failed to unzip '" + zipEntry.getName() + "'to '" + tempFile.getAbsolutePath() + "'", ioe);
                    }
                }
            }
        }
    }

    private static class Dir
    extends VirtualDir {
        private final File dir;

        private Dir(File file) {
            this.dir = file;
        }

        @Override
        public String getBasePath() {
            return this.dir.getPath();
        }

        @Override
        public File getBaseFile() {
            return this.dir;
        }

        @Override
        public InputStream getInputStream(String path) throws IOException {
            if (path.endsWith(".gz")) {
                return new GZIPInputStream(new BufferedInputStream(new FileInputStream(this.getFile(path))));
            }
            return new BufferedInputStream(new FileInputStream(this.getFile(path)));
        }

        @Override
        public File getFile(String path) throws IOException {
            File child = this.dir.toPath().resolve(path).toFile();
            if (!child.exists()) {
                throw new FileNotFoundException(child.getPath());
            }
            return child;
        }

        @Override
        public String[] list(String path) throws IOException {
            File child = this.getFile(path);
            return child.list();
        }

        @Override
        public boolean exists(String path) {
            File child = new File(this.dir, path);
            return child.exists();
        }

        @Override
        public String[] listAllFiles() throws IOException {
            Path path = Paths.get(this.dir.getAbsolutePath(), new String[0]);
            try (Stream<Path> pathStream = Files.walk(path, new FileVisitOption[0]);){
                Stream<Path> filteredstream = pathStream.filter(new Predicate<Path>(){

                    @Override
                    public boolean test(Path path) {
                        return Files.isRegularFile(path, new LinkOption[0]);
                    }
                });
                final int baseLength = path.toUri().toString().length();
                Stream<String> fileStream = filteredstream.map(new Function<Path, String>(){

                    @Override
                    public String apply(Path path) {
                        return path.toUri().toString().substring(baseLength);
                    }
                });
                String[] stringArray = (String[])fileStream.toArray((IntFunction<A[]>)new IntFunction<String[]>(){

                    @Override
                    public String[] apply(int value) {
                        return new String[value];
                    }
                });
                return stringArray;
            }
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isCompressed() {
            return false;
        }

        @Override
        public boolean isArchive() {
            return false;
        }
    }
}

