/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ExtensionFactory;
import java.lang.reflect.Constructor;

public class SingleTypeExtensionFactory<T, E>
implements ExtensionFactory {
    private final Class<E> extensionType;
    private final Class<? extends E> extensionSubType;

    public SingleTypeExtensionFactory(Class<E> extensionType) {
        this(extensionType, extensionType);
    }

    public SingleTypeExtensionFactory(Class<E> extensionType, Class<? extends E> extensionSubType) {
        Assert.argument(extensionType.isAssignableFrom(extensionSubType), "extensionType.isAssignableFrom(extensionSubType)");
        this.extensionType = extensionType;
        this.extensionSubType = extensionSubType;
    }

    public final Class<E> getExtensionType() {
        return this.extensionType;
    }

    public final Class<? extends E> getExtensionSubType() {
        return this.extensionSubType;
    }

    public final E getExtension(Object object, Class<?> extensionType) {
        if (this.extensionType.isAssignableFrom(extensionType)) {
            try {
                return (E)this.getExtensionImpl(object, extensionType);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        return null;
    }

    protected E getExtensionImpl(T object, Class<E> extensionType) throws Throwable {
        Class<E> subType = this.getExtensionSubType();
        try {
            Constructor<E> constructor = subType.getConstructor(object.getClass());
            return constructor.newInstance(object);
        }
        catch (Exception e) {
            return subType.newInstance();
        }
    }

    @Override
    public final Class<?>[] getExtensionTypes() {
        if (this.extensionType.equals(this.extensionSubType)) {
            return new Class[]{this.getExtensionSubType()};
        }
        return new Class[]{this.getExtensionSubType(), this.getExtensionType()};
    }
}

