/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.DefaultServiceRegistry;
import com.bc.ceres.core.ServiceRegistry;
import java.util.HashMap;

public class ServiceRegistryManager {
    private static ServiceRegistryManager instance = new ServiceRegistryManager();
    private final HashMap<Class, ServiceRegistry> serviceRegistries = new HashMap(10);

    public static ServiceRegistryManager getInstance() {
        return instance;
    }

    public static void setInstance(ServiceRegistryManager instance) {
        Assert.notNull(instance, "instance");
        ServiceRegistryManager.instance = instance;
    }

    public <T> ServiceRegistry<T> getServiceRegistry(Class<T> serviceType) {
        Assert.notNull(serviceType, "serviceType");
        ServiceRegistry<T> serviceRegistry = this.serviceRegistries.get(serviceType);
        if (serviceRegistry == null) {
            serviceRegistry = this.createServiceRegistry(serviceType);
            this.setServiceRegistry(serviceType, serviceRegistry);
        }
        return serviceRegistry;
    }

    public <T> void setServiceRegistry(Class<T> serviceType, ServiceRegistry<T> serviceRegistry) {
        this.serviceRegistries.put(serviceType, serviceRegistry);
    }

    protected <T> ServiceRegistry<T> createServiceRegistry(Class<T> serviceType) {
        Assert.notNull(serviceType, "serviceType");
        return new DefaultServiceRegistry<T>(serviceType);
    }
}

