/*
 * Decompiled with CFR 0.152.
 */
package eu.esa.snap.netbeans.docwin;

import eu.esa.snap.netbeans.docwin.Bundle;
import eu.esa.snap.netbeans.docwin.DocumentWindow;
import eu.esa.snap.netbeans.docwin.DocumentWindowManager;
import eu.esa.snap.netbeans.docwin.NotifiableComponent;
import eu.esa.snap.netbeans.docwin.WindowContainer;
import eu.esa.snap.netbeans.docwin.WindowUtilities;
import eu.esa.snap.netbeans.tile.TileUtilities;
import eu.esa.snap.netbeans.tile.Tileable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.netbeans.swing.tabcontrol.DefaultTabDataModel;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbed;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="WorkspaceTopComponent", persistenceType=1)
public class WorkspaceTopComponent
extends TopComponent
implements WindowContainer<TopComponent>,
Tileable {
    public static final String ID = WorkspaceTopComponent.class.getSimpleName();
    private static final Logger LOG = Logger.getLogger(WorkspaceTopComponent.class.getName());
    private final Map<TabData, JInternalFrame> tabToFrameMap;
    private final Map<JInternalFrame, TabData> frameToTabMap = new HashMap<JInternalFrame, TabData>();
    private final Map<Object, Rectangle> idToBoundsMap;
    private final ActionListener tabActionListener;
    private final InternalFrameListener internalFrameListener;
    private final PropertyChangeListener propertyChangeListener;
    private final FrameProxyLookup lookup;
    private TabbedContainer tabbedContainer;
    private JDesktopPane desktopPane;

    public WorkspaceTopComponent() {
        this(Bundle.CTL_WorkspaceTopComponentNameBase());
    }

    public WorkspaceTopComponent(String displayName) {
        this.tabToFrameMap = new HashMap<TabData, JInternalFrame>();
        this.idToBoundsMap = new HashMap<Object, Rectangle>();
        this.tabActionListener = new TabActionListener();
        this.internalFrameListener = new MyInternalFrameListener();
        this.propertyChangeListener = new MyPropertyChangeListener();
        this.lookup = new FrameProxyLookup();
        this.associateLookup((Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{this}), this.lookup}));
        this.initComponents();
        this.setName(displayName);
        this.setDisplayName(displayName);
        this.setToolTipText(Bundle.CTL_WorkspaceTopComponentDescription());
    }

    public static WorkspaceTopComponent findShowingInstance() {
        TopComponent activated = WindowManager.getDefault().getRegistry().getActivated();
        if (activated instanceof WorkspaceTopComponent) {
            return (WorkspaceTopComponent)activated;
        }
        List<WorkspaceTopComponent> showingWorkspaces = WorkspaceTopComponent.findShowingInstances();
        if (!showingWorkspaces.isEmpty()) {
            return showingWorkspaces.get(0);
        }
        return null;
    }

    public static List<WorkspaceTopComponent> findShowingInstances() {
        return WindowUtilities.getOpened(WorkspaceTopComponent.class).filter(Component::isShowing).collect(Collectors.toList());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        DefaultTabDataModel tabDataModel = new DefaultTabDataModel();
        this.tabbedContainer = new TabbedContainer((TabDataModel)tabDataModel, 1, WinsysInfoForTabbedContainer.getDefault((WinsysInfoForTabbed)new MyWinsysInfoForTabbedContainer()));
        this.tabbedContainer.setVisible(false);
        this.desktopPane = new JDesktopPane();
        this.add((Component)this.tabbedContainer, "North");
        this.add(this.desktopPane, "Center");
    }

    public UndoRedo getUndoRedo() {
        TopComponent topComponent = this.getActiveTopComponent();
        if (topComponent != null) {
            return topComponent.getUndoRedo();
        }
        return super.getUndoRedo();
    }

    @Override
    public TopComponent getSelectedWindow() {
        return this.getActiveTopComponent();
    }

    @Override
    public List<TopComponent> getOpenedWindows() {
        return this.getTopComponents();
    }

    public TopComponent getActiveTopComponent() {
        JInternalFrame selectedFrame = this.desktopPane.getSelectedFrame();
        return selectedFrame != null ? this.getTopComponent(selectedFrame) : null;
    }

    public List<TopComponent> getTopComponents() {
        List tabs = this.tabbedContainer.getModel().getTabs();
        ArrayList<TopComponent> topComponents = new ArrayList<TopComponent>();
        for (TabData tab : tabs) {
            JInternalFrame internalFrame = this.tabToFrameMap.get(tab);
            topComponents.add(this.getTopComponent(internalFrame));
        }
        return topComponents;
    }

    @Override
    public boolean canTile() {
        return this.frameToTabMap.size() >= 2;
    }

    @Override
    public void tileEvenly() {
        new TileEvenlyAction().actionPerformed(null);
    }

    @Override
    public void tileHorizontally() {
        new TileHorizontallyAction().actionPerformed(null);
    }

    @Override
    public void tileVertically() {
        new TileVerticallyAction().actionPerformed(null);
    }

    @Override
    public void tileSingle() {
        new TileSingleAction().actionPerformed(null);
    }

    public void addTopComponent(TopComponent topComponent) {
        String displayName;
        List tabs = this.tabbedContainer.getModel().getTabs();
        for (TabData tab : tabs) {
            JInternalFrame internalFrame = this.tabToFrameMap.get(tab);
            if (topComponent != this.getTopComponent(internalFrame)) continue;
            try {
                internalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            return;
        }
        if (topComponent.isOpened()) {
            topComponent.close();
        }
        if ((displayName = topComponent.getDisplayName()) == null) {
            displayName = Bundle.CTL_WorkspaceTopComponentFrameUnnamed();
        }
        JInternalFrame internalFrame = new JInternalFrame(displayName, true, true, true, true);
        Image iconImage = topComponent.getIcon();
        ImageIcon imageIcon = null;
        if (iconImage != null) {
            imageIcon = new ImageIcon(iconImage);
            internalFrame.setFrameIcon(imageIcon);
        }
        JPanel dummyComponent = new JPanel();
        dummyComponent.setPreferredSize(new Dimension(-1, 4));
        TabData tab = new TabData((Object)dummyComponent, (Icon)imageIcon, displayName, null);
        this.frameToTabMap.put(internalFrame, tab);
        this.tabToFrameMap.put(tab, internalFrame);
        internalFrame.setContentPane((Container)topComponent);
        Object internalFrameID = this.getInternalFrameID(topComponent);
        Rectangle bounds = this.idToBoundsMap.get(internalFrameID);
        if (bounds == null) {
            int count = this.frameToTabMap.size() % 5;
            bounds = new Rectangle(count * 24, count * 24, 400, 400);
        }
        internalFrame.setBounds(bounds);
        this.tabbedContainer.getModel().addTab(this.tabbedContainer.getModel().size(), tab);
        this.tabbedContainer.setVisible(true);
        this.desktopPane.add(internalFrame);
        internalFrame.addInternalFrameListener(this.internalFrameListener);
        internalFrame.setVisible(true);
        try {
            internalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        topComponent.addPropertyChangeListener(this.propertyChangeListener);
    }

    public boolean removeTopComponent(TopComponent topComponent) {
        JInternalFrame internalFrame = this.getInternalFrame(topComponent);
        return internalFrame != null && this.closeInternalFrame(internalFrame) == topComponent;
    }

    public static Action[] getExtraActions(TopComponent topComponent) {
        return new Action[]{new FloatIntoWorkspaceAction(topComponent), new FloatGroupIntoWorkspaceAction(topComponent)};
    }

    public Action[] getActions() {
        Action[] actions = super.getActions();
        ArrayList<Action> actionList = new ArrayList<Action>();
        actionList.add(new RenameWorkspaceAction());
        if (actions.length > 0) {
            actionList.add(null);
            actionList.addAll(Arrays.asList(actions));
        }
        if (this.tabbedContainer.getTabCount() > 0) {
            actionList.add(null);
            actionList.add(new TileEvenlyAction());
            actionList.add(new TileHorizontallyAction());
            actionList.add(new TileVerticallyAction());
        }
        return actionList.toArray(new Action[actionList.size()]);
    }

    public TopComponent.SubComponent[] getSubComponents() {
        HashMap<TopComponent.SubComponent, JInternalFrame> internalFrameMap = new HashMap<TopComponent.SubComponent, JInternalFrame>();
        TopComponent.SubComponent[] subComponents = new TopComponent.SubComponent[this.tabbedContainer.getTabCount()];
        ActionListener activator = actionEvent -> {
            JInternalFrame internalFrame = (JInternalFrame)internalFrameMap.get(actionEvent.getSource());
            try {
                internalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            internalFrame.requestFocusInWindow();
        };
        for (int i = 0; i < subComponents.length; ++i) {
            TabData tab = this.tabbedContainer.getModel().getTab(i);
            JInternalFrame internalFrame = this.tabToFrameMap.get(tab);
            TopComponent.SubComponent subComponent = new TopComponent.SubComponent(internalFrame.getTitle(), internalFrame.getToolTipText(), activator, internalFrame.isSelected(), this.getTopComponent(internalFrame).getLookup(), internalFrame.isShowing());
            internalFrameMap.put(subComponent, internalFrame);
            subComponents[i] = subComponent;
        }
        return subComponents;
    }

    protected void componentOpened() {
        this.tabbedContainer.addActionListener(this.tabActionListener);
    }

    protected void componentClosed() {
        this.tabbedContainer.removeActionListener(this.tabActionListener);
        for (JInternalFrame internalFrame : this.desktopPane.getAllFrames()) {
            internalFrame.dispose();
        }
    }

    protected void componentActivated() {
        JInternalFrame selectedFrame = this.desktopPane.getSelectedFrame();
        if (selectedFrame != null) {
            TabData tab = this.frameToTabMap.get(selectedFrame);
            int tabIndex = this.tabbedContainer.getModel().indexOf(tab);
            if (tabIndex >= 0) {
                this.tabbedContainer.getSelectionModel().setSelectedIndex(tabIndex);
            }
            selectedFrame.requestFocusInWindow();
            this.notifyActivated(this.getTopComponent(selectedFrame));
        } else {
            TabData tab;
            int tabIndex = this.tabbedContainer.getSelectionModel().getSelectedIndex();
            if (tabIndex >= 0 && !(selectedFrame = this.tabToFrameMap.get(tab = this.tabbedContainer.getModel().getTab(tabIndex))).isSelected()) {
                try {
                    selectedFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    protected void componentDeactivated() {
        JInternalFrame selectedFrame = this.desktopPane.getSelectedFrame();
        if (selectedFrame != null) {
            this.notifyDeactivated(this.getTopComponent(selectedFrame));
        }
    }

    protected void componentShowing() {
        for (JInternalFrame internalFrame : this.desktopPane.getAllFrames()) {
            NotifiableComponent.get(this.getTopComponent(internalFrame)).componentShowing();
        }
    }

    protected void componentHidden() {
        for (JInternalFrame internalFrame : this.desktopPane.getAllFrames()) {
            NotifiableComponent.get(this.getTopComponent(internalFrame)).componentHidden();
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private TopComponent closeInternalFrame(JInternalFrame internalFrame) {
        return this.closeInternalFrame(internalFrame, true);
    }

    private TopComponent closeInternalFrame(JInternalFrame internalFrame, boolean removeTab) {
        internalFrame.removeInternalFrameListener(this.internalFrameListener);
        TopComponent topComponent = this.getTopComponent(internalFrame);
        topComponent.removePropertyChangeListener(this.propertyChangeListener);
        Object internalFrameID = this.getInternalFrameID(topComponent);
        this.idToBoundsMap.put(internalFrameID, new Rectangle(internalFrame.getBounds()));
        TabData tab = this.frameToTabMap.get(internalFrame);
        if (tab != null) {
            int tabIndex;
            if (removeTab && (tabIndex = this.tabbedContainer.getModel().indexOf(tab)) >= 0) {
                this.tabbedContainer.getModel().removeTab(tabIndex);
            }
            this.tabToFrameMap.remove(tab);
        }
        this.frameToTabMap.remove(internalFrame);
        internalFrame.dispose();
        this.desktopPane.remove(internalFrame);
        if (this.desktopPane.getComponentCount() == 0) {
            this.tabbedContainer.setVisible(false);
        }
        internalFrame.setContentPane((Container)new TopComponent());
        return topComponent;
    }

    private TopComponent dockInternalFrame(JInternalFrame internalFrame) {
        TopComponent topComponent = this.closeInternalFrame(internalFrame, true);
        Mode mode = WindowManager.getDefault().findMode("editor");
        mode.dockInto(topComponent);
        if (!topComponent.isOpened()) {
            topComponent.open();
        }
        return topComponent;
    }

    private TopComponent getTopComponent(JInternalFrame internalFrame) {
        return (TopComponent)internalFrame.getContentPane();
    }

    private JInternalFrame getInternalFrame(TopComponent topComponent) {
        for (JInternalFrame internalFrame : this.frameToTabMap.keySet()) {
            if (topComponent != this.getTopComponent(internalFrame)) continue;
            return internalFrame;
        }
        return null;
    }

    private JInternalFrame getInternalFrame(int tabIndex) {
        TabData tab = this.tabbedContainer.getModel().getTab(tabIndex);
        return this.tabToFrameMap.get(tab);
    }

    private Object getInternalFrameID(TopComponent topComponent) {
        Object internalFrameID = topComponent.getClientProperty((Object)"internalFrameID");
        if (internalFrameID == null) {
            internalFrameID = "IF" + Long.toHexString(new Random().nextLong());
            topComponent.putClientProperty((Object)"internalFrameID", internalFrameID);
        }
        return internalFrameID;
    }

    private void notifyOpened(TopComponent topComponent) {
        NotifiableComponent.get(topComponent).componentOpened();
        if (topComponent instanceof DocumentWindow) {
            DocumentWindowManager.getDefault().addOpenedWindow((DocumentWindow)topComponent);
        }
    }

    private void notifyClosed(TopComponent topComponent) {
        NotifiableComponent.get(topComponent).componentClosed();
        if (topComponent instanceof DocumentWindow) {
            DocumentWindowManager.getDefault().removeOpenedWindow((DocumentWindow)topComponent);
        }
    }

    private void notifyActivated(TopComponent topComponent) {
        NotifiableComponent.get(topComponent).componentActivated();
        if (topComponent instanceof DocumentWindow) {
            DocumentWindowManager.getDefault().setSelectedWindow((DocumentWindow)topComponent);
        }
    }

    private void notifyDeactivated(TopComponent topComponent) {
        NotifiableComponent.get(topComponent).componentDeactivated();
    }

    public boolean requestActiveTopComponent(TopComponent topComponent) {
        JInternalFrame internalFrame = this.getInternalFrame(topComponent);
        if (internalFrame != null) {
            try {
                internalFrame.setSelected(true);
                return true;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        return false;
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            TopComponent source = (TopComponent)event.getSource();
            JInternalFrame frame = WorkspaceTopComponent.this.getInternalFrame(source);
            if ("icon".equals(event.getPropertyName())) {
                Image icon = source.getIcon();
                if (icon != null) {
                    frame.setFrameIcon(new ImageIcon(icon));
                } else {
                    frame.setFrameIcon(null);
                }
                TabData tab = WorkspaceTopComponent.this.frameToTabMap.get(frame);
                assert (tab != null);
                int i = WorkspaceTopComponent.this.tabbedContainer.getModel().indexOf(tab);
                if (i >= 0) {
                    if (icon != null) {
                        WorkspaceTopComponent.this.tabbedContainer.getModel().setIcon(i, (Icon)new ImageIcon(icon));
                    } else {
                        WorkspaceTopComponent.this.tabbedContainer.getModel().setIcon(i, null);
                    }
                }
            } else if ("displayName".equals(event.getPropertyName())) {
                String displayName = source.getDisplayName();
                frame.setTitle(displayName);
                TabData tab = WorkspaceTopComponent.this.frameToTabMap.get(frame);
                assert (tab != null);
                int i = WorkspaceTopComponent.this.tabbedContainer.getModel().indexOf(tab);
                if (i >= 0) {
                    WorkspaceTopComponent.this.tabbedContainer.getModel().setText(i, displayName);
                }
            }
        }
    }

    private class MyWinsysInfoForTabbedContainer
    extends WinsysInfoForTabbedContainer {
        private MyWinsysInfoForTabbedContainer() {
        }

        public Object getOrientation(Component comp) {
            return TabDisplayer.ORIENTATION_CENTER;
        }

        public boolean inMaximizedMode(Component comp) {
            JInternalFrame internalFrame = WorkspaceTopComponent.this.desktopPane.getSelectedFrame();
            return internalFrame != null && internalFrame.isMaximum();
        }
    }

    private class MyInternalFrameListener
    implements InternalFrameListener {
        private MyInternalFrameListener() {
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent e) {
            WorkspaceTopComponent.this.tabbedContainer.updateUI();
            WorkspaceTopComponent.this.notifyOpened(WorkspaceTopComponent.this.getTopComponent(e.getInternalFrame()));
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e) {
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
            JInternalFrame internalFrame = e.getInternalFrame();
            if (WorkspaceTopComponent.this.frameToTabMap.containsKey(internalFrame)) {
                WorkspaceTopComponent.this.closeInternalFrame(internalFrame);
            }
            WorkspaceTopComponent.this.tabbedContainer.updateUI();
            WorkspaceTopComponent.this.notifyClosed(WorkspaceTopComponent.this.getTopComponent(internalFrame));
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            JInternalFrame internalFrame = e.getInternalFrame();
            TabData selectedTab = WorkspaceTopComponent.this.frameToTabMap.get(internalFrame);
            int selectedTabIndex = WorkspaceTopComponent.this.tabbedContainer.getSelectionModel().getSelectedIndex();
            List tabs = WorkspaceTopComponent.this.tabbedContainer.getModel().getTabs();
            for (int i = 0; i < tabs.size(); ++i) {
                TabData tab = (TabData)tabs.get(i);
                if (tab != selectedTab || selectedTabIndex == i) continue;
                WorkspaceTopComponent.this.tabbedContainer.getSelectionModel().setSelectedIndex(i);
                break;
            }
            WorkspaceTopComponent.this.tabbedContainer.updateUI();
            TopComponent topComponent = WorkspaceTopComponent.this.getTopComponent(internalFrame);
            WorkspaceTopComponent.this.lookup.setLookup(topComponent.getLookup());
            WorkspaceTopComponent.this.setActivatedNodes(topComponent.getActivatedNodes());
            if (WorkspaceTopComponent.this != WindowManager.getDefault().getRegistry().getActivated()) {
                WorkspaceTopComponent.this.requestActive();
            }
            WorkspaceTopComponent.this.notifyActivated(topComponent);
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent e) {
            WorkspaceTopComponent.this.tabbedContainer.updateUI();
            WorkspaceTopComponent.this.lookup.setLookup(Lookup.EMPTY);
            WorkspaceTopComponent.this.notifyDeactivated(WorkspaceTopComponent.this.getTopComponent(e.getInternalFrame()));
        }

        @Override
        public void internalFrameIconified(InternalFrameEvent e) {
            WorkspaceTopComponent.this.tabbedContainer.updateUI();
            TopComponent topComponent = WorkspaceTopComponent.this.getTopComponent(e.getInternalFrame());
            NotifiableComponent.get(topComponent).componentHidden();
        }

        @Override
        public void internalFrameDeiconified(InternalFrameEvent e) {
            WorkspaceTopComponent.this.tabbedContainer.updateUI();
            TopComponent topComponent = WorkspaceTopComponent.this.getTopComponent(e.getInternalFrame());
            NotifiableComponent.get(topComponent).componentShowing();
        }
    }

    private static class FrameProxyLookup
    extends ProxyLookup {
        private FrameProxyLookup() {
        }

        void setLookup(Lookup lookup) {
            this.setLookups(new Lookup[]{lookup});
        }
    }

    public static class FloatGroupIntoWorkspaceAction
    extends AbstractAction {
        private TopComponent window;

        public FloatGroupIntoWorkspaceAction(TopComponent window) {
            super(Bundle.CTL_FloatGroupIntoWorkspaceActionName());
            this.window = window;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WorkspaceTopComponent workspaceTopComponent = FloatIntoWorkspaceAction.promptForWorkspaces();
            if (workspaceTopComponent != null) {
                workspaceTopComponent.requestActive();
                Mode mode = WindowManager.getDefault().findMode(this.window);
                if (mode != null) {
                    TopComponent[] topComponents;
                    for (TopComponent topComponent : topComponents = WindowManager.getDefault().getOpenedTopComponents(mode)) {
                        if (topComponent instanceof WorkspaceTopComponent) continue;
                        workspaceTopComponent.addTopComponent(topComponent);
                    }
                }
            }
        }
    }

    public static class FloatIntoWorkspaceAction
    extends AbstractAction {
        private TopComponent window;

        public FloatIntoWorkspaceAction(TopComponent window) {
            super(Bundle.CTL_FloatIntoWorkspaceActionName());
            this.window = window;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WorkspaceTopComponent workspaceTopComponent = FloatIntoWorkspaceAction.promptForWorkspaces();
            if (workspaceTopComponent != null) {
                workspaceTopComponent.requestActive();
                workspaceTopComponent.addTopComponent(this.window);
            }
        }

        static WorkspaceTopComponent promptForWorkspaces() {
            List workspaces = WindowUtilities.getOpened(WorkspaceTopComponent.class).collect(Collectors.toList());
            WorkspaceTopComponent workspaceTopComponent = null;
            if (workspaces.size() == 1) {
                workspaceTopComponent = (WorkspaceTopComponent)workspaces.get(0);
            } else if (workspaces.size() > 1) {
                List displayNames = workspaces.stream().map(TopComponent::getDisplayName).collect(Collectors.toList());
                JPanel panel = new JPanel(new BorderLayout(2, 2));
                panel.setBorder(new EmptyBorder(8, 8, 8, 8));
                panel.add((Component)new JLabel(Bundle.LBL_FloatIntoWorkspaceActionName()), "North");
                JList listComponent = new JList(new Vector(displayNames));
                listComponent.setVisibleRowCount(6);
                listComponent.setSelectedIndex(0);
                panel.add(new JScrollPane(listComponent));
                DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.CTL_FloatIntoWorkspaceActionTitle());
                DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
                Object result = dd.getValue();
                if (DialogDescriptor.OK_OPTION.equals(result)) {
                    int selectedIndex = listComponent.getSelectedIndex();
                    if (selectedIndex < 0) {
                        selectedIndex = 0;
                    }
                    workspaceTopComponent = (WorkspaceTopComponent)workspaces.get(selectedIndex);
                }
            } else {
                TopComponent topComponent = WindowManager.getDefault().findTopComponent(ID);
                if (topComponent instanceof WorkspaceTopComponent) {
                    workspaceTopComponent = (WorkspaceTopComponent)topComponent;
                    workspaceTopComponent.open();
                }
            }
            return workspaceTopComponent;
        }
    }

    private class DockGroupAction
    extends AbstractAction {
        public DockGroupAction() {
            super(Bundle.CTL_DockGroupActionName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Set<JInternalFrame> internalFrameSet = WorkspaceTopComponent.this.frameToTabMap.keySet();
            JInternalFrame[] internalFrames = internalFrameSet.toArray(new JInternalFrame[internalFrameSet.size()]);
            TopComponent topComponent = null;
            for (JInternalFrame internalFrame : internalFrames) {
                topComponent = WorkspaceTopComponent.this.dockInternalFrame(internalFrame);
            }
            if (topComponent != null) {
                topComponent.requestActive();
            }
        }
    }

    private class DockAction
    extends AbstractAction {
        private int tabIndex;

        public DockAction(int tabIndex) {
            super(Bundle.CTL_DockActionName());
            this.tabIndex = tabIndex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabData tab = WorkspaceTopComponent.this.tabbedContainer.getModel().getTab(this.tabIndex);
            JInternalFrame internalFrame = WorkspaceTopComponent.this.tabToFrameMap.get(tab);
            TopComponent topComponent = WorkspaceTopComponent.this.dockInternalFrame(internalFrame);
            if (topComponent != null) {
                topComponent.requestActive();
            }
        }
    }

    private class TileSingleAction
    extends AbstractAction {
        public TileSingleAction() {
            super(Bundle.CTL_TileSingleActionName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame[] internalFrames;
            int desktopWidth = WorkspaceTopComponent.this.desktopPane.getWidth();
            int desktopHeight = WorkspaceTopComponent.this.desktopPane.getHeight();
            for (JInternalFrame internalFrame : internalFrames = WorkspaceTopComponent.this.desktopPane.getAllFrames()) {
                internalFrame.setBounds(0, 0, desktopWidth, desktopHeight);
            }
        }
    }

    private class TileVerticallyAction
    extends AbstractAction {
        public TileVerticallyAction() {
            super(Bundle.CTL_TileVerticallyActionName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int desktopWidth = WorkspaceTopComponent.this.desktopPane.getWidth();
            int desktopHeight = WorkspaceTopComponent.this.desktopPane.getHeight();
            int windowCount = WorkspaceTopComponent.this.frameToTabMap.size();
            int windowHeight = desktopHeight / windowCount;
            List tabs = WorkspaceTopComponent.this.tabbedContainer.getModel().getTabs();
            for (int windowIndex = 0; windowIndex < windowCount; ++windowIndex) {
                TabData tab = (TabData)tabs.get(windowIndex);
                JInternalFrame internalFrame = WorkspaceTopComponent.this.tabToFrameMap.get(tab);
                internalFrame.setBounds(0, windowIndex * windowHeight, desktopWidth, windowHeight);
            }
        }
    }

    private class TileHorizontallyAction
    extends AbstractAction {
        public TileHorizontallyAction() {
            super(Bundle.CTL_TileHorizontallyActionName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int desktopWidth = WorkspaceTopComponent.this.desktopPane.getWidth();
            int desktopHeight = WorkspaceTopComponent.this.desktopPane.getHeight();
            int windowCount = WorkspaceTopComponent.this.frameToTabMap.size();
            int windowWidth = desktopWidth / windowCount;
            List tabs = WorkspaceTopComponent.this.tabbedContainer.getModel().getTabs();
            for (int windowIndex = 0; windowIndex < windowCount; ++windowIndex) {
                TabData tab = (TabData)tabs.get(windowIndex);
                JInternalFrame internalFrame = WorkspaceTopComponent.this.tabToFrameMap.get(tab);
                internalFrame.setBounds(windowIndex * windowWidth, 0, windowWidth, desktopHeight);
            }
        }
    }

    private class TileEvenlyAction
    extends AbstractAction {
        public TileEvenlyAction() {
            super(Bundle.CTL_TileEvenlyActionName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int desktopWidth = WorkspaceTopComponent.this.desktopPane.getWidth();
            int desktopHeight = WorkspaceTopComponent.this.desktopPane.getHeight();
            int windowCount = WorkspaceTopComponent.this.frameToTabMap.size();
            Dimension matrixSize = TileUtilities.computeMatrixSizeForEqualAreaTiling(windowCount);
            int windowWidth = desktopWidth / matrixSize.width;
            int windowHeight = desktopHeight / matrixSize.height;
            List tabs = WorkspaceTopComponent.this.tabbedContainer.getModel().getTabs();
            int windowIndex = 0;
            for (int j = 0; j < matrixSize.height; ++j) {
                for (int i = 0; i < matrixSize.width; ++i) {
                    if (windowIndex < windowCount) {
                        TabData tab = (TabData)tabs.get(windowIndex);
                        JInternalFrame internalFrame = WorkspaceTopComponent.this.tabToFrameMap.get(tab);
                        internalFrame.setBounds(i * windowWidth, j * windowHeight, windowWidth, windowHeight);
                    }
                    ++windowIndex;
                }
            }
        }
    }

    private class MaximizeWindowAction
    extends AbstractAction {
        private final int tabIndex;

        public MaximizeWindowAction(int tabIndex) {
            super(Bundle.CTL_MaximizeWindowActionName());
            this.tabIndex = tabIndex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabData tab = WorkspaceTopComponent.this.tabbedContainer.getModel().getTab(this.tabIndex);
            JInternalFrame internalFrame = WorkspaceTopComponent.this.tabToFrameMap.get(tab);
            try {
                internalFrame.setMaximum(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private class CloseOtherWindowsAction
    extends AbstractAction {
        private final int tabIndex;

        public CloseOtherWindowsAction(int tabIndex) {
            super(Bundle.CTL_CloseOtherWindowsActionName());
            this.tabIndex = tabIndex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame[] internalFrames;
            TabData tab = WorkspaceTopComponent.this.tabbedContainer.getModel().getTab(this.tabIndex);
            JInternalFrame selectedInternalFrame = WorkspaceTopComponent.this.tabToFrameMap.get(tab);
            Set<JInternalFrame> internalFrameSet = WorkspaceTopComponent.this.frameToTabMap.keySet();
            for (JInternalFrame internalFrame : internalFrames = internalFrameSet.toArray(new JInternalFrame[internalFrameSet.size()])) {
                if (internalFrame == selectedInternalFrame) continue;
                WorkspaceTopComponent.this.closeInternalFrame(internalFrame);
            }
        }
    }

    private class CloseAllWindowsAction
    extends AbstractAction {
        public CloseAllWindowsAction() {
            super(Bundle.CTL_CloseAllWindowsActionName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new CloseOtherWindowsAction(-1).actionPerformed(e);
        }
    }

    private class CloseWindowAction
    extends AbstractAction {
        private final int tabIndex;

        public CloseWindowAction(int tabIndex) {
            super(Bundle.CTL_CloseWindowActionName());
            this.tabIndex = tabIndex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabData tab = WorkspaceTopComponent.this.tabbedContainer.getModel().getTab(this.tabIndex);
            JInternalFrame internalFrame = WorkspaceTopComponent.this.tabToFrameMap.get(tab);
            WorkspaceTopComponent.this.closeInternalFrame(internalFrame);
        }
    }

    private class RenameWorkspaceAction
    extends AbstractAction {
        public RenameWorkspaceAction() {
            super(Bundle.CTL_RenameActionName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NotifyDescriptor.InputLine d = new NotifyDescriptor.InputLine("Name:", "Rename Workspace");
            d.setInputText(WorkspaceTopComponent.this.getDisplayName());
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            if (NotifyDescriptor.OK_OPTION.equals(result)) {
                WorkspaceTopComponent.this.setDisplayName(d.getInputText());
            }
        }
    }

    private abstract class TabAction
    extends AbstractAction {
        private TabAction(String name) {
            super(name);
            this.putValue("ActionCommandKey", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e instanceof TabActionEvent) {
                this.tabActionPerformed((TabActionEvent)e);
            }
        }

        public abstract void tabActionPerformed(TabActionEvent var1);
    }

    private class TabActionListener
    implements ActionListener {
        private final Map<String, Action> tabActions = new HashMap<String, Action>();

        private TabActionListener() {
            this.initTabActions();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Action action = this.tabActions.get(actionEvent.getActionCommand());
            if (action != null) {
                action.actionPerformed(actionEvent);
            }
        }

        private void initTabActions() {
            this.addTabAction(new TabAction("close"){

                @Override
                public void tabActionPerformed(TabActionEvent actionEvent) {
                    int tabIndex = actionEvent.getTabIndex();
                    JInternalFrame internalFrame = WorkspaceTopComponent.this.getInternalFrame(tabIndex);
                    if (internalFrame != null) {
                        WorkspaceTopComponent.this.closeInternalFrame(internalFrame, false);
                    }
                }
            });
            this.addTabAction(new TabAction("select"){

                @Override
                public void tabActionPerformed(TabActionEvent actionEvent) {
                    int tabIndex = actionEvent.getTabIndex();
                    JInternalFrame internalFrame = WorkspaceTopComponent.this.getInternalFrame(tabIndex);
                    if (internalFrame != null) {
                        try {
                            if (internalFrame.isIcon()) {
                                internalFrame.setIcon(false);
                            }
                            internalFrame.setSelected(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
            });
            this.addTabAction(new TabAction("maximize"){

                @Override
                public void tabActionPerformed(TabActionEvent actionEvent) {
                    int tabIndex = actionEvent.getTabIndex();
                    new MaximizeWindowAction(tabIndex).actionPerformed((ActionEvent)actionEvent);
                }
            });
            this.addTabAction(new TabAction("popup"){

                @Override
                public void tabActionPerformed(TabActionEvent actionEvent) {
                    int tabCount = WorkspaceTopComponent.this.tabbedContainer.getTabCount();
                    if (tabCount == 0) {
                        return;
                    }
                    int tabIndex = actionEvent.getTabIndex();
                    JPopupMenu popupMenu = new JPopupMenu();
                    if (tabIndex >= 0) {
                        popupMenu.add(new CloseWindowAction(tabIndex));
                    }
                    if (tabCount > 1) {
                        popupMenu.add(new CloseAllWindowsAction());
                    }
                    if (tabIndex >= 0 && tabCount > 1) {
                        popupMenu.add(new CloseOtherWindowsAction(tabIndex));
                    }
                    if (tabIndex >= 0 || tabCount > 1) {
                        popupMenu.addSeparator();
                        if (tabIndex >= 0) {
                            popupMenu.add(new MaximizeWindowAction(tabIndex));
                            popupMenu.add(new DockAction(tabIndex));
                        }
                        if (tabCount > 1) {
                            popupMenu.add(new DockGroupAction());
                        }
                    }
                    if (tabCount > 1) {
                        popupMenu.addSeparator();
                        popupMenu.add(new TileEvenlyAction());
                        popupMenu.add(new TileHorizontallyAction());
                        popupMenu.add(new TileVerticallyAction());
                    }
                    popupMenu.show((Component)WorkspaceTopComponent.this.tabbedContainer, actionEvent.getMouseEvent().getX(), actionEvent.getMouseEvent().getY());
                }
            });
        }

        private void addTabAction(Action action) {
            this.tabActions.put((String)action.getValue("ActionCommandKey"), action);
        }
    }
}

