/*
 * Decompiled with CFR 0.152.
 */
package eu.esa.snap.netbeans.docwin;

import eu.esa.snap.netbeans.docwin.WindowContainer;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openide.windows.TopComponent;

public class WindowUtilities {
    static final TcProvider DEFAULT_TC_PROVIDER;
    static TcProvider tcProvider;

    public static String getUniqueTitle(String titleBase, Class<? extends TopComponent> windowType) {
        List titles = WindowUtilities.getOpened(windowType).map(TopComponent::getDisplayName).collect(Collectors.toList());
        if (titles.isEmpty()) {
            return titleBase;
        }
        if (!titles.contains(titleBase)) {
            return titleBase;
        }
        int i = 2;
        String title;
        while (titles.contains(title = String.format("%s (%d)", titleBase, i))) {
            ++i;
        }
        return title;
    }

    public static <T> Stream<T> getOpened(Class<T> type) {
        return tcProvider.getOpened().stream().flatMap(topComponent -> {
            if (topComponent instanceof WindowContainer) {
                return Stream.concat(Stream.of(topComponent), ((WindowContainer)topComponent).getOpenedWindows().stream());
            }
            return Stream.of(topComponent);
        }).filter(topComponent -> type.isAssignableFrom(topComponent.getClass())).map(topComponent -> topComponent);
    }

    static {
        tcProvider = DEFAULT_TC_PROVIDER = () -> TopComponent.getRegistry().getOpened();
    }

    static interface TcProvider {
        public Collection<TopComponent> getOpened();
    }
}

